#include "mbed.h"

#define EEPROM_ADDR   (0b10100000) // EEPROM address

I2C i2c(I2C_SDA, I2C_SCL);
DigitalOut myled(LED1); // Activate LED
DigitalIn mybutton(USER_BUTTON); // Activate button
DigitalInOut data_pin(A0); // Activate digital in
Serial pc(SERIAL_TX, SERIAL_RX); // Initialize UART connection
// Use a terminal program (eg. putty).
Timer tmr; //initialize timer
uint64_t adat; // 64 bit variable for temporary data
int i;
char data_write[4]; //Array for address and data
char eeprom_read_address[2] = {0, 0};
char data_read[2];

// Function to initialize DHT11
void dht_read(void)
{
    data_pin.output(); // Set A0 as output
    // Initialize measurement > 18 ms low
    data_pin = 0;
    wait_ms(20);
    // After high and release the pin switch input mode
    data_pin = 1;
    data_pin.input();
    // Wait until the end of 80 us low
    while(!data_pin.read()) {}
    // Wait until end of 80 us high
    while(data_pin.read()) {}
    // 40 bit, 40 read out cycle
    for(i=0; i<40; i++) {
        adat = adat << 1; // Shift for new number
        tmr.stop(); // Stop timer if runs
        tmr.reset();  // Reset timer
        // Wait until pin
        while(!data_pin.read()) {}
        tmr.start();
        while(data_pin.read()) {}
        // If DHT11 HIGH longer than 40 micro seconds (hopefully 70 us)
        if(tmr.read_us() > 40) {
            // bit is 1
            adat++;
        }
    }
}

int main()
{
    pc.printf("Log the DHT11 temperature and humidity sensor!\n\r"); //Welcome message
    while(1) {
        if (mybutton == 0) { // Button is pressed
            pc.printf("\n\rLogged humidity and temperature:\n\r"); //Welcome message
            myled = 1; // LED is ON
            i2c.write(EEPROM_ADDR, eeprom_read_address, 2, true);
            for( i=0; i < 30; i++ ) {
                i2c.read(EEPROM_ADDR, data_read, 2);
                pc.printf("%d %d\n\r",data_read[0], data_read[1]);
            }
            wait(3); // Wait 0.2 sec till continue.
        } else {
            myled =1;
            wait(0.1);
            adat = 0; // Resed global adat variable
            dht_read(); // Call the function
            // Save data to EEPROM
            data_write[2] = (adat  & 0x000000ff00000000) >> 32; // Humidity
            data_write[3] = (adat & 0x0000000000ff0000) >> 16 ; // Temperature
            i2c.write(EEPROM_ADDR, data_write, 4);
            myled = 0; // LED is OFF
            wait(1.8);
        }
    }
}
