#include "mbed.h"

DigitalIn mybutton(USER_BUTTON); // Activate button
DigitalOut chipselect(D10); // ChipSelect (CS) pin
SPI eeprom(SPI_MOSI, SPI_MISO, SPI_SCK); // Activate SPI to ST eeprom
Serial pc(SERIAL_TX, SERIAL_RX);

#define WREN 0x06
#define RDSR 0x05
#define READ_LOW 0x03
#define WRITE_LOW 0x02
 
int main() {
    char char_in = 't';
    char char_out;
    int i = 0;

    chipselect =1;
    eeprom.frequency(1000000); // set 1 MHz clock rate
    while(1) {
        if (mybutton == 0) { // Button is pressed
            chipselect = 0;
            eeprom.write(RDSR);
            eeprom.write(0x00);
            chipselect = 1;
            chipselect = 0;
            eeprom.write(WREN);
            chipselect = 1;
            wait_us(1);
            while((char_in == 'y') == (char_in == 'n')){
                pc.printf("\n\rDo you want type in some characters? Answer (y/n): ");
                char_in=pc.getc();
                pc.putc(char_in);
                if((char_in != 'n') == (char_in != 'y')) {
                    pc.printf("\n\rPlease substitute %c with (y/n)-t", char_in);
                }
            }
            if(char_in == 'y'){
                pc.printf("\n\rWrite something (max. 16 chars): ");
                i = 0;
                while(i < 16){
                    char_in=pc.getc();
                    if(char_in == '\n'){
                        i = 16;
                        break;
                    }
                    chipselect = 0;
                    eeprom.write(WREN);
                    chipselect = 1;
                    wait_us(1);
                    chipselect = 0;
                    eeprom.write(WRITE_LOW);
                    eeprom.write(i);
                    eeprom.write(char_in);
                    chipselect = 1;
                    i++;
                    pc.putc(char_in);
                }
                char_in = 't';
            }
            if(char_in == 'n'){
                pc.printf("\n\rFirst page: ");
                for(i=0; i<16; i++){
                    chipselect = 0;
                    eeprom.write(READ_LOW);
                    eeprom.write(i);
                    char_out = eeprom.write(0x00);
                    chipselect = 1;
                    pc.putc(char_out);
                }
                char_in = 't';
            }
            pc.printf("\n\r");
            wait(2);
        }
    }
}
 