#include "mbed.h"

#define mBED2

#define VCC 3.3
#define B 3984
#define K 273
#define T0 (K+25)
#define R0 10000
#define TEMP_LIMIT 35

#ifdef mBED1
    #define R1A 10037
    #define R1B 10056
    #define R2A 10047
    #define R2B 10012
    #define R3A 10041
    #define R3B 10048
    
    #define RLOW  80.4
    #define RHIGH 99.3
#else
    #define R1A 10033
    #define R1B 10023
    #define R2A  9988
    #define R2B 10036
    #define R3A 10070
    #define R3B 10067
    
    #define RLOW  9.8
    #define RHIGH 80.4
#endif
 
Serial pc(USBTX, USBRX); // tx, rx
DigitalOut buzzer(p22);
LocalFileSystem local("local");

BusIn chipStatus(p27, p29, p30, p28);
//(p27, p29, p30, p28)
//(p28, p30, p29, p27)

float res_to_temp(float res);
float volt_to_temp(int batteryA, float volt);
float volt_to_res(int batteryA, float volt);
 
int main() {
    
    char myname[64];
    float voltageA = .0, voltageB = .0;
    float tempA = .0, tempB = .0;
    int i, bus;
    char status[60];
    char p;
    FILE *fp;
    double bat_volt = .0;
    
    #ifdef mBED1
        int mBed = 1;
    #else
        int mBed = 2;
    #endif
    
    buzzer = 0;
    
    pc.printf("\n\n\n");    
    
    for (i = 0; i < 1000; i++) {
        sprintf(myname, "/local/log%04d.csv", i);
        //pc.printf("Try file: <%s>\n", myname);    
        if ((fp = fopen(myname, "r")) == 0) {
            //pc.printf("File not found: <%s>\n", myname);
            break;
        } else {
            //pc.printf("File exists: <%s>\n", myname);
            fclose(fp);
        }
    }
    
    pc.printf("Creating File: <%s>\n", myname);
    fp = fopen(myname, "w");
    
    pc.printf("Please enter a file name: \n");
    p = pc.getc();
    while(p != '\n'){
       fprintf(fp, "%c", p);
       pc.printf("%c", p);
       p = pc.getc();
    }
    fprintf(fp, "\n");
    pc.printf("\n");
    
    fprintf(fp, "mBed, tempA, tempB, Battery, Status, bus\n");
    
    AnalogIn battery_voltage(p16);
    AnalogIn va1(p17);
    AnalogIn va2(p18);
    AnalogIn vb1(p19);
    AnalogIn vb2(p20);
    
    DigitalIn charge(p30);
    DigitalIn fault(p29);
    DigitalIn TOC (p28);
    DigitalIn ready(p27);
    
    DigitalIn run(p21);
    
    while(run) {
        voltageA = (va1.read() - va2.read())*3.3;
        voltageB = (vb1.read() - vb2.read())*3.3;
        //resA = volt_to_res(1, voltageA);
        //resB = volt_to_res(0, voltageB);
        tempA = volt_to_temp(1, voltageA);
        tempB = volt_to_temp(0, voltageB);
        bus = chipStatus.read();
        
        
        switch(bus)  {
            case 0: sprintf(status,"Off"); break;
            case 8: sprintf(status,"Ready to Charge"); break;
            case 10: sprintf(status,"Precharge or Fast Charge"); break;
            case 11: sprintf(status,"NiMH Top-Off Charge"); break;
            case 12: sprintf(status," Temperature Limits"); break;
            case 13: sprintf(status," Temperature Limits"); break;
            case 14: sprintf(status," Temperature Limits"); break;
            case 15: sprintf(status," Temperature Limits"); break;
            case 4:  sprintf(status,"Fault State (Latched)"); break;
            default: sprintf(status,"Unknown: %d", bus); break;
        }
        
        bat_volt = VCC * (battery_voltage.read_u16() / 65536.0) / (RLOW / (RHIGH + RLOW));
            
        pc.printf("mBed%i: tempA: %f, tempB: %f, Battery: %f (%f), Status: %s, BusIn %d\n", mBed, tempA-K, tempB-K, bat_volt, battery_voltage.read(), status, bus);
        fprintf(fp, "%i, %f, %f, %f, %s, %d\n", mBed, tempA-K, tempB-K, bat_volt, status, bus);
        
        if(((tempA-K) > TEMP_LIMIT) || ((tempB-K) > TEMP_LIMIT)){
            buzzer = 1;
        } 
        
        wait_ms(5000);       
    }
    
    fclose(fp); 
    
}

float volt_to_temp(int batteryA, float volt){
    float res = volt_to_res(batteryA, volt);
    return res_to_temp(res);
}

float volt_to_res(int batteryA, float volt){
    if(batteryA){
        return R3A * ((VCC * R2A - volt * (R1A + R2A)) / (VCC * R1A + volt * (R1A + R2A)));
    }else{
        return R3B * ((VCC * R2B - volt * (R1B + R2B)) / (VCC * R1B + volt * (R1B + R2B)));
    }
}

float res_to_temp(float Rt){
    
    return (B * T0) / (B + (T0 * log(Rt / R0)));
    
}

