// ----- Libraries ------------------------------------------------------------------
#include "mbed.h"
#include "ultrasonic.h"

// ----- Constants ------------------------------------------------------------------


// ----- I/O Pins -------------------------------------------------------------------
AnalogIn ultra_lef(A2);
AnalogIn ultra_rig(A3);

// ----- Others ---------------------------------------------------------------------


// ----- Variables ------------------------------------------------------------------
double read_sensor, cm;

// ----- Functions ------------------------------------------------------------------
float ultrasonicos(int sensor){
    double inch, volts;
    if (sensor == ULTRA_R) {
        read_sensor = ultra_rig;                 // read analog as a float         
    }else if (sensor == ULTRA_L) {
        read_sensor = ultra_lef;                 // read analog as a float    
    }
    // read_sensor * 3300mv / 6.4 mV/in * 2.54 in/cms
    volts = read_sensor * 3300;
    inch = volts / 6.4;
    cm = inch * 2.54;
    return cm;
}