// ----- Libraries ------------------------------------------------------------------
#include "mbed.h"
#include "motors.h"

// ----- I/O Pins -------------------------------------------------------------------
// MOTORS (Control)
DigitalOut dir_left(D5);
DigitalOut dir_right(D6);
PwmOut pwm_left(D9);
PwmOut pwm_right(D10);

// ----- Functions ------------------------------------------------------------------

void motor_fwd(int _power_left, int _power_right){
    dir_left = 1;
    dir_right = 1;
    pwm_left = (float)_power_left/100;
    pwm_right = (float)_power_right/100;
    //pc.printf("FWD\n");
}

void motor_rev(int _power_left, int _power_right){
    dir_left = 0;
    dir_right = 0;
    pwm_left = (float)_power_left/100;
    pwm_right = (float)_power_right/100;
    //pc.printf("REV\n");
}

void motor_left(int _power_left, int _power_right){
    dir_left = 0;
    dir_right = 1;
    pwm_left = (float)_power_left/100;
    pwm_right = (float)_power_right/100;
    //pc.printf("LEFT\n");
}

void motor_right(int _power_left, int _power_right){
    dir_left = 1;
    dir_right = 0;
    pwm_left = (float)_power_left/100;
    pwm_right = (float)_power_right/100;
    //pc.printf("RIGHT\n");
}

void motor_stop(){
    dir_left = 1;
    dir_right = 1;
    pwm_left = 0;
    pwm_right = 0;
    //pc.printf("STOP\n");
}
