// ----- Libraries ------------------------------------------------------------------
#include "mbed.h"
#include "encoders.h"

// ----- I/O Pins -------------------------------------------------------------------
InterruptIn interrupt_encoder_der(D2);
InterruptIn interrupt_encoder_izq(D3);


int flanco_bajada_rigth;
int flanco_bajada_left;

// ----- Functions ------------------------------------------------------------------
void encoders_to_zero(){
    flanco_bajada_rigth = 0;
    flanco_bajada_left = 0;
}

void falling_encoder_rigth(void){
    flanco_bajada_rigth++;
}
 
void falling_encoder_left(void){
    flanco_bajada_left++;
}

void init_encoders(){
    interrupt_encoder_der.fall(&falling_encoder_rigth);
    interrupt_encoder_izq.fall(&falling_encoder_left);
}

float encoder(int sensor_encoder){
        int read_encoder = 0;
        float distancia;
        
        if(sensor_encoder==encoder_rigth){ 
            read_encoder= flanco_bajada_rigth;
                        
        }else if(sensor_encoder==encoder_left){
            read_encoder= flanco_bajada_left;
                    
        }
        distancia= (read_encoder/5)*2.2580;
        
        return distancia; 
}