// ----- Libraries ------------------------------------------------------------------
#include "mbed.h"
#include "sd_card.h"

// ----- Constants ------------------------------------------------------------------


// ----- I/O Pins -------------------------------------------------------------------
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // MOSI, MISO, SCK, CS

// ----- Others ---------------------------------------------------------------------
FILE *fp;

// ----- Variables ------------------------------------------------------------------
int lat_points[10], lon_points[10];
int points_gps;


// ----- Functions ------------------------------------------------------------------
void savefile_sd(){
    FILE *fp = fopen("/sd/gps_points.txt", "w");
    if (fp == 0){
        //printf("Could not open file\n");
    }else{
        for (int i = 0; i < points_gps; i++){
            fprintf(fp, "%f\t%f", lat_points[i], lon_points[i]);
            fprintf(fp, "\r\n");
        }
    }
    fclose(fp);
}

