// ----- Libraries ------------------------------------------------------------------
#include "mbed.h"
#include "FXOS8700CQ.h"
#include "magnometer.h"

// ----- I/O Pins -------------------------------------------------------------------
FXOS8700CQ fxos(PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1); // SDA, SCL, (addr << 1)

// ----- Others ---------------------------------------------------------------------
SRAWDATA accel_data;
SRAWDATA magn_data;

// ----- Variables ------------------------------------------------------------------
double mag_x, mag_y;
double avg_x, avg_y;
//double average;

// ----- Functions ------------------------------------------------------------------
void init_magnometer(){
    fxos.enable();
}

double get_mag_x(){
    fxos.get_data(&accel_data, &magn_data);
    return magn_data.x;
}

double get_mag_y(){
    fxos.get_data(&accel_data, &magn_data);
    return magn_data.y;
}

double get_mag_angle(){
    double _angle;
    
    for (int i = 0; i < 10; i++){
        fxos.get_data(&accel_data, &magn_data);
        avg_x += magn_data.x;
        avg_y += magn_data.y;
        //pc.printf("X: %d \tY: %d\r\n", magn_data.x, magn_data.y);
        //pc.printf("%d\n", magn_data.x);
    }
    
    avg_x = avg_x / 10.0;
    avg_y = avg_y / 10.0;
    
    //pc.printf("%d\n", avg_x);
    _angle = atan2(-avg_y, avg_x) * 180.0 / 3.14159;
    return _angle;
}