#include "mbed.h"
#include "TextLCD.h"

//TEA5767 example with STM32 nucleo
//Developed by Mazzella, Vitone, (un po')Tarallo

TextLCD lcd(D12, D11, D5, D4, D3, D2, TextLCD::LCD16x2);
I2C radio(D14, D15); //sda, sc1
AnalogIn trimmer(PA_0);// A0 ingresso analogico



float frequenza;
unsigned int N,m1,m2;
char config_t[5];


const int addr = 0xC0; //address for writing data, reading is C1

int main()
{
    while (1) {
        frequenza=(108-87.5)*trimmer.read()+87.5;
        N=4*(frequenza*1e6+225000)/32768;
        //a questo punto dobbiamo converitre in esadecimale N ed inviarlo al modulo radio
        // usando unsigned int n sappiamo con sicurezza di utilizzare solo 2 byte
        m2=N & 0x00FF;//isoliamo il secondo byte di N
        m1=N & 0xFF00;//isoliamo il primo byte di N,dobbiamo però shifarlo
        m1=m1>>8;

        config_t[0] = char(m1);
        config_t[1] = char(m2); // config data byte, tune at 100.00MHz
        config_t[2] = 0x10;
        config_t[3] = 0x12;
        config_t[4] = 0x00;

        radio.write(addr, config_t, 5);

        lcd.locate(0,0);
        lcd.printf("Frequenza: ");
        lcd.locate(0,1);
        lcd.printf("%-2.2f", frequenza );
        lcd.printf("MHz ");

        wait(0.3);
    }


}
