#include "mbed.h"

//TEA5767 example with STM32 nucleo
//Developed by Mazzella, Vitone, Tarallo

I2C radio(D14, D15); //sda, sc1

Serial pc(USBTX, USBRX); //tx, rx
InterruptIn button (USER_BUTTON);

const int addr = 0xC0; //address for writing data, reading is C1

char config_t[5];
char search[5];


void seqfreq()          //search next frequency, minimun signal strength
{
    search[0] = 0x6F;
    search[1] = 0xCA;
    search[2] = 0xB0;
    search[3] = 0x12;
    search[4] = 0x00;
    radio.write(addr, search, 5);

}

int main()
{

    config_t[0] = 0x2F;
    config_t[1] = 0xCA; // config data byte, tune at 100.00MHz
    config_t[2] = 0x10;
    config_t[3] = 0x12;
    config_t[4] = 0x00;

    radio.write(addr, config_t, 5);
    button.rise(&seqfreq);

}
