#include <jsonlite.h>
#include "M2XStreamClient.h"

#include "mbed.h"
#include "EthernetInterface.h"
#include "LM75B.h"  //I2C Temperature Sensor

char feedId[] = "<feed id>"; // Feed you want to post to
char m2xKey[] = "<m2x api key>"; // Your M2X access key
char streamName[] = "<stream name>"; // Stream you want to post to

char name[] = "<location name>"; // Name of current location of datasource
double latitude = 33.007872;
double longitude = -96.751614; // You can also read those values from a GPS
double elevation = 697.00;

Client client;
M2XStreamClient m2xClient(&client, m2xKey);

EthernetInterface eth;
LM75B tmp(p28,p27);         // I2C Temperature Sensor

void on_data_point_found(const char* at, const char* value, int index, void* context) {
  printf("Found a data point, index: %d\r\n", index);
  printf("At: %s Value: %s\r\n", at, value);
}

void on_location_found(const char* name,
                       double latitude,
                       double longitude,
                       double elevation,
                       const char* timestamp,
                       int index,
                       void* context) {
  printf("Found a location, index: %d\r\n", index);
  printf("Name: %s  Latitude: %lf  Longitude: %lf\r\n", name, latitude, longitude);
  printf("Elevation: %lf  Timestamp: %s\r\n", elevation, timestamp);
}

int main() {
  eth.init();
  eth.connect();
  printf("IP Address: %s\r\n", eth.getIPAddress());

  char amb_temp[6];
  
  while (true) {
  
    // read temp
    sprintf(amb_temp, "%0.2f", tmp.read());
    
    // post temperature
    int response = m2xClient.post(feedId, streamName, amb_temp);
    printf("Post response code: %d\r\n", response);
    if (response == -1) while (true) ;
    
    // read temperature
    response = m2xClient.fetchValues(feedId, streamName, on_data_point_found, NULL);
    printf("Fetch response code: %d\r\n", response);
    if (response == -1) while (true) ;
    
    // update location
    response = m2xClient.updateLocation(feedId, name, latitude, longitude, elevation);
    printf("updateLocation response code: %d\r\n", response);
    if (response == -1) while (true) ;
    
    // read location
    response = m2xClient.readLocation(feedId, on_location_found, NULL);
    printf("readLocation response code: %d\r\n", response);
    if (response == -1) while (true) ;

    // wait 60 secs and then loop
    delay(60000);
  }
}