#include "mbed.h"
#include "MMA8451Q.h"
#include "M2XStreamClient.h"
#include "include_me.h"
#include "math.h"

#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)

using namespace mts;

const char key[] = "<key>";       // Replace with your M2X user account master key
const char feed[] = "<feed>";     // Replace with your blueprint feed ID
const char stream[] = "<stream>"; // Replace with your stream name

// set to 1 for cellular shield board
// set to 0 for wifi shield board
#define CELL_SHIELD 0

// ssid and phrase for wifi
std::string ssid = "<ssid>";        // Replace with your Wifi ID (SSID)
std::string phrase = "<password>";  // Replace with your Wifi phrase (password)
Wifi::SecurityType security_type = Wifi::WPA; // Replace with your Wifi security type

int main()
{
#if CELL_SHIELD
    MTSSerialFlowControl* serial = new MTSSerialFlowControl(PTD3, PTD2, PTA12, PTC8);
    serial->baud(115200);
    Transport::setTransport(Transport::CELLULAR);
    Cellular* cell = Cellular::getInstance();
    cell->init(serial, PTA4, PTC9); //DCD and DTR pins for KL46Z

    int max_tries = 5;
    int i;
    std::string apn = "wap.cingular";  // set to the appropriate APN (i.e. "m2m.com.attz" for M2X SIMs)

    i = 0;
    while (i++ < max_tries) {
        if (cell->getRegistration() == Cellular::REGISTERED) {
            printf("registered with tower\n\r");
            break;
        } else if (i >= max_tries) {
            printf("failed to register with tower\n\r");
        } else {
            wait(3);
        }
    }

    printf("signal strength: %d\n\r", cell->getSignalStrength());

    i = 0;
    printf("setting APN to %s\n\r", apn.c_str());
    while (i++ < max_tries) {
        if (cell->setApn(apn) == SUCCESS) {
            printf("successfully set APN\n\r");
            break;
        } else if (i >= max_tries) {
            printf("failed to set APN\n\r");
        } else {
            wait(1);
        }
    }

    i = 0;
    printf("bringing up PPP link\n\r");
    while (i++ < max_tries) {
        if (cell->connect()) {
            printf("PPP link is up\n\r");
            break;
        } else if (i >= max_tries) {
            printf("failed to bring PPP link up\n\r");
        } else {
            wait(1);
        }
    }
#else
    // WiFi shield
    for (int i = 6; i >= 0; i = i - 2) {
        wait(2);
        printf("Waiting %d seconds...\n\r", i);
    }
    MTSSerial* serial = new MTSSerial(PTD3, PTD2, 256, 256);
    serial->baud(9600);
    Transport::setTransport(Transport::WIFI);
    Wifi* wifi = Wifi::getInstance();
    printf("Init: %s\n\r", wifi->init(serial) ? "SUCCESS" : "FAILURE");
    printf("Set Network: %s\n\r", getCodeNames(wifi->setNetwork(ssid, security_type, phrase)).c_str());
    printf("Set DHCP: %s\n\r", getCodeNames(wifi->setDeviceIP("DHCP")).c_str());
    printf("Signal Strnegth (dBm): %d\n\r", wifi->getSignalStrength());
    printf("Is Connected: %s\n\r", wifi->isConnected() ? "True" : "False");
    printf("Connect: %s\n\r", wifi->connect() ? "Success" : "Failure");
    printf("Is Connected: %s\n\r", wifi->isConnected() ? "True" : "False");
#endif

    // Initialize the M2X client
    Client client;
    M2XStreamClient m2xClient(&client, key);
    int ret;
    
    // Create an accelerometer instance
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    
    printf("MMA8451 ID: %d\n", acc.getWhoAmI());

    // Add code here to read accelerometer data and post to M2X stream
    // ...
    
}