#include "mbed.h"
#include "FXOS8700Q.h"
#include "M2XStreamClient.h"
#include "include_me.h"
#include "math.h"

using namespace mts;

char deviceId[] = "<device id>"; // Device you want to push to
char streamName[] = "<stream name>"; // Stream you want to push to
char m2xKey[] = "<m2x api key>"; // Your M2X API Key or Master API Key

// set to 1 for cellular shield board
// set to 0 for wifi shield board
#define CELL_SHIELD 0
#define SUCCESS 1

// ssid and phrase for wifi
std::string ssid = "<ssid>";        // Replace with your Wifi ID (SSID)
std::string phrase = "<password>";  // Replace with your Wifi phrase (password)
Wifi::SecurityType security_type = Wifi::WPA; // Replace with your Wifi security type

int main()
{
    printf("starting\n\r");
#if CELL_SHIELD
    MTSSerialFlowControl* serial = new MTSSerialFlowControl(PTC17, PTC16, PTA1, PTC2);
    serial->baud(115200);
    Transport::setTransport(Transport::CELLULAR);
    Cellular* cell = Cellular::getInstance();
    cell->init(serial, PTA2, PTE25); //DCD and DTR pins for K64F

    int max_tries = 5;
    int i;
    std::string apn = "wap.cingular";  // set to the appropriate APN (i.e. "m2m.com.attz" for M2X SIMs, "wap.cingular" for others)

    i = 0;
    while (i++ < max_tries) {
        if (cell->getRegistration() == Cellular::REGISTERED) {
            printf("registered with tower\n\r");
            break;
        } else if (i >= max_tries) {
            printf("failed to register with tower\n\r");
        } else {
            wait(3);
        }
    }

    printf("signal strength: %d\n\r", cell->getSignalStrength());

    i = 0;
    printf("setting APN to %s\n\r", apn.c_str());
    while (i++ < max_tries) {
        if (cell->setApn(apn) == SUCCESS) {
            printf("successfully set APN\n\r");
            break;
        } else if (i >= max_tries) {
            printf("failed to set APN\n\r");
        } else {
            wait(1);
        }
    }

    i = 0;
    printf("bringing up PPP link\n\r");
    while (i++ < max_tries) {
        if (cell->connect()) {
            printf("PPP link is up\n\r");
            break;
        } else if (i >= max_tries) {
            printf("failed to bring PPP link up\n\r");
        } else {
            wait(1);
        }
    }
#else
    // WiFi shield
    for (int i = 6; i >= 0; i = i - 2) {
        wait(2);
        printf("Waiting %d seconds...\n\r", i);
    }
    MTSSerial* serial = new MTSSerial(PTC17, PTC16, 256, 256);
    serial->baud(9600);
    Transport::setTransport(Transport::WIFI);
    Wifi* wifi = Wifi::getInstance();
    printf("Init: %s\n\r", wifi->init(serial) ? "SUCCESS" : "FAILURE");
    printf("Set Network: %s\n\r", getCodeNames(wifi->setNetwork(ssid, security_type, phrase)).c_str());
    printf("Set DHCP: %s\n\r", getCodeNames(wifi->setDeviceIP("DHCP")).c_str());
    printf("Signal Strnegth (dBm): %d\n\r", wifi->getSignalStrength());
    printf("Is Connected: %s\n\r", wifi->isConnected() ? "True" : "False");
    printf("Connect: %s\n\r", wifi->connect() ? "Success" : "Failure");
    printf("Is Connected: %s\n\r", wifi->isConnected() ? "True" : "False");
#endif

    // Initialize the M2X client
    Client client;
    M2XStreamClient m2xClient(&client, m2xKey);
    int ret;

    // Add code below to read accelerometer data and post to M2X stream
    // ...

    // Create an accelerometer instance
    FXOS8700Q_acc acc( PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1); // Proper Ports and I2C Address for K64F Freedom board
    acc.enable();
    printf("\r\n\nFXOS8700Q Who Am I= %X\r\n", acc.whoAmI());

    while (true) {

        float x, y, z;
        acc.getX(&x);
        acc.getY(&y);
        acc.getZ(&z);

        printf("Accel X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);

        // Calculate pitch and roll. Find the maximum tilt angle.
        float pitch = atan(x / sqrt(y * y + z * z));
        float roll = atan(y / sqrt(x * x + z * z));
        float maxTilt =
            max(abs(roll), abs(pitch)) * 180.0 / 3.14159;
        printf("pitch: %5.1f roll: %5.1f maxTilt: %5.1f\n\r",
               pitch, roll, maxTilt);

        // If the maximum title is over 20 degrees, then send
        // data to stream
        if (maxTilt > 20) {
            ret = m2xClient.updateStreamValue(deviceId, streamName, maxTilt);
            printf("send() returned %d\r\n", ret);
            wait(1.0);
        }
    }
}