/* =====================================================================
   Copyright © 2016, Avnet (R)

   Contributors:
     * James M Flynn, www.em.avnet.com 
 
   Licensed under the Apache License, Version 2.0 (the "License"); 
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, 
   software distributed under the License is distributed on an 
   "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
   either express or implied. See the License for the specific 
   language governing permissions and limitations under the License.

    @file          WNCInterface.cpp
    @version       1.0
    @date          Sept 2016

======================================================================== */

#include "mbed.h"
#include "WNCInterface.h"

#define DEBUG
#define MBED_PLATFORM
#include "HTTPClient.h"

#define DELAY_INTERVAL 10000

#define CRLF    "\n\r"

#define ntohl(n)    ((n & 0xff) << 24) |\
                    ((n & 0xff00) << 8) |\
                    ((n & 0xff0000UL) >> 8) |\
                    ((n & 0xff000000UL) >> 24)

int main() {
    int ret;
    WNCInterface wnc;
    MODSERIAL pc(USBTX,USBRX,256,256);
    
    pc.baud(115200);
    pc.printf("STARTING WNCInterface Info" CRLF);
    
    wnc.doDebug(3); 
    ret = wnc.init();
    pc.printf("WNC Module %s initialized (%02X)." CRLF, ret?"IS":"IS NOT", ret);
    if( !ret ) {
        printf(" - - - - - - - ALL DONE - - - - - - - " CRLF);
        while(1);
    }
        
    ret = wnc.connect();                 
    printf("IP Address: %s " CRLF CRLF, wnc.getIPAddress());

    

    wnc.disconnect();
    printf(" - - - - - - - ALL DONE - - - - - - - " CRLF);
}

