#include "mbed.h"

AnalogIn xAxis(A0);
AnalogIn yAxis(A1);

int x,y,button;  // global variables to hold values
Ticker joystick; // recurring interrupt to get joystick data

void joystick_Int_Handler()
{
    x = xAxis.read() * 1000; // float (0->1) to int (0-1000)
    y = yAxis.read() * 1000;
    if ( (x > 900) || (y > 900) )
        button = 1;
    else
        button = 0;
}

int main() 
{
    // init interrupt, call every .2s
    joystick.attach(joystick_Int_Handler,0.2);
    
    // Print out the variables
    while(1){
        printf("\rX=%3d, Y=%3d, Button=%d",x,y,button);
    }
}
