#include "mbed.h"
#include "ADXL345_I2C.h"


//#define LED                 // Grove LED
//#define ACCEL               // SEN04051P Grove - 3-Axis Digital Accelerometer(±16g)
//#define LIGHT_SENSOR        // Grove Light Sensor using GL5528 photoresistor 
//#define WATER_SENSOR        // Grove Water Sensor
//#define GAS_SENSOR          // SEN90512P Grove - Gas Sensor(MQ2)
#define TEMP_SENSOR           // Grove Temperature Sensor using TTC03 Thermistor 

 
AnalogIn temp_sensor(A0);     
AnalogIn analog_light_sensor_read(A1); 
DigitalIn water_sensor(A2);
AnalogIn gas_sensor(A3);
DigitalOut my_led(D7);
ADXL345_I2C accelerometer(D14, D15);

        
int main() {
    
    float vol;
    float Rsensor;
    int gas_sensor_value;
    int sound_sensor_value;
    int adc_scale = 4096; 
    int readings[3] = {0, 0, 0};
    int sensorValue;
    int B = 3975;
    float resistance; 
    float temperature;
    float temperature_f;  
    char amb_temp[6];
    int a;
    
#ifdef ACCEL     
    printf("Starting ADXL345 test...\n\r");
    wait(.001);
    printf("Device ID is: 0x%02x\n\r", accelerometer.getDeviceID());
    wait(.001);
    
    // These are here to test whether any of the initialization fails. It will print the failure
    if (accelerometer.setPowerControl(0x00))
    {
         printf("didn't intitialize power control\n"); 
         return 0;  
    }
    
    //Full resolution, +/-16g, 4mg/LSB.
    wait(.001);
     
    if(accelerometer.setDataFormatControl(0x0B))
    {
        printf("didn't set data format\n");
        return 0;  
    }
    wait(.001);
     
     //3.2kHz data rate.
    if(accelerometer.setDataRate(ADXL345_3200HZ))
    {
        printf("didn't set data rate\n");
        return 0;    
    }
    wait(.001);
     
    //Measurement mode.     
    if(accelerometer.setPowerControl(MeasurementMode)) 
    {
        printf("didn't set the power control to measurement\n"); 
        return 0;   
    } 
#endif
    
    while(1) 
    {
#ifdef LED        
        my_led = 1; // LED is ON
        wait(0.2); // 200 ms
        my_led = 0; // LED is OFF
        wait(1.0); // 1 sec
#endif

#ifdef WATER_SENSOR        
        printf("water_sensor: %d \n\r", water_sensor.read());   
        wait(0.5);                  
#endif

#ifdef GAS_SENSOR        
        gas_sensor_value = gas_sensor.read_u16();
        printf("gas_sensor_value: 0x%X \n\r", gas_sensor_value);          

        vol = (float)gas_sensor_value/adc_scale*5.0;
        printf("gas vol: %f \n\r", vol);  
        wait(1);          
#endif

#ifdef ACCEL
        accelerometer.getOutput(readings);     
        wait(0.1); // 100 ms        
            
        /* x-axis, y-axis and z-axis */        
        printf("%d, %d, %d\n\r", (int16_t)readings[0], (int16_t)readings[1], (int16_t)readings[2]);
#endif

#ifdef LIGHT_SENSOR
        sensorValue = analog_light_sensor_read.read_u16();               
        Rsensor=(float)(adc_scale-sensorValue)*10/sensorValue;
        printf("Light Sensor Analog Reading is 0x%X = %d   ", sensorValue, sensorValue);        
        printf("The sensor resistance is %f  \n\n\r", Rsensor);  
        wait(1); // 1s  
#endif
      
#ifdef TEMP_SENSOR
        a = temp_sensor.read_u16();
               
        resistance = (float)(adc_scale-a)*10000/a; //get the resistance of the sensor;              
        temperature = 1/(log(resistance/10000)/B+1/298.15)-273.15;  //convert to temperature via datasheet ;        
        temperature_f = (1.8 * temperature) + 32.0;
        sprintf(amb_temp, "%0.2f", temperature_f);  
        
        printf("Temp Sensor Analog Reading is 0x%X = %d   ", a, a);         
        printf("Current Temperature: %f C  %f F \n\r", temperature, temperature_f); 
        wait(1); // 1s          
#endif      
              
    }
}
