#include "mbed.h"
#include "FXOS8700Q.h"
#include "M2XStreamClient.h"
#include "ESP8266Interface.h"
#include "TCPSocketConnection.h"


#ifndef MAX
#define max(a,b) ({ __typeof__ (a) _a = (a); __typeof__ (b) _b = (b); _a > _b ? _a : _b; })
#endif

#ifndef MIN
#define min(a,b) ({ __typeof__ (a) _a = (a); __typeof__ (b) _b = (b); _a < _b ? _a : _b; })
#endif

char deviceId[] = "<device id>"; // Device you want to push to
char streamName[] = "<stream name>"; // Stream you want to push to
char m2xKey[] = "<m2x api key>"; // Your M2X API Key or Master API Key

/*
*  ESP8266 Wifi Config, connect it to D0 on Seeed Grove shield
*/
ESP8266Interface wifi(D1,D0,D3,"wifi-name","wifi-password",115200); // TX,RX,Reset,SSID,Password,Baud 

int main()
{
    printf("Starting...\r\n");

    // connect to wifi
    wifi.init(); //Reset
    wifi.connect(); //Use DHCP
    printf("IP Address is %s \n\r", wifi.getIPAddress());

    // Initialize the M2X client
    Client client;
    M2XStreamClient m2xClient(&client, m2xKey,1,"52.22.150.98");
    int ret;

    // Create an accelerometer instance
    FXOS8700Q_acc acc( PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1); // Proper Ports and I2C Address for K64F Freedom board
    acc.enable();
    printf("\r\n\nFXOS8700Q Who Am I= %X\r\n", acc.whoAmI());

    while (true) {

        float x, y, z;
        acc.getX(&x);
        acc.getY(&y);
        acc.getZ(&z);

        printf("Accel X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);

        // Calculate pitch and roll. Find the maximum tilt angle.
        float pitch = atan(x / sqrt(y * y + z * z));
        float roll = atan(y / sqrt(x * x + z * z));
        float maxTilt =
            max(abs(roll), abs(pitch)) * 180.0 / 3.14159;
        printf("pitch: %5.1f roll: %5.1f maxTilt: %5.1f\n\r",
               pitch, roll, maxTilt);

        // If the maximum title is over 20 degrees, then send
        // data to stream
        
            ret = m2xClient.updateStreamValue(deviceId, streamName, maxTilt);
            printf("send() returned %d\r\n", ret);
            wait(1.0);
        
    }
}