#include "mbed.h"
#include "math.h"
#include "TextLCD.h"

#define muestras 100
#define bufferLength 500

TextLCD lcd(D8, D9, D2, D3, D4, D5, TextLCD::LCD16x2); // rs, e, d4-d7
Serial pc(USBTX, USBRX); // tx, rx

Serial bt(PC_0, PC_1); // tx, rx

//lcd.cls();
//lcd.printf("Media: %3.4f\n", medidas.media);

int contador=0;
int flag=0;
int bufferActivo=0;
int mostrarDato=0;


AnalogIn tension(A0);
AnalogIn intensidad(A1);
AnalogIn adcMedio(A2);



char inputdata = 0;


InterruptIn boton(USER_BUTTON);

struct Vectores {
    int16_t  vTensionA[muestras];
    int16_t  vTensionB[muestras];
    int16_t  vIntensidadA[muestras];
    int16_t  vIntensidadB[muestras];
} vectores;

struct Medidas {
    float Vrms;
    float Irms;
    float potenciaActiva;    //ok
    float potenciaReactiva;  //ok
    float potenciaAparente;  //ok
    float potenciaActivaAC;
    float potenciaReactivaAC;
    float factorDePotencia;  //ok
} medidas;


Ticker tcaptura;
Ticker tmostrar;
void captura();
void visualizacion();
//void visualizacion_blu();
void cambiar();

float calcularP(int16_t *datosV, int16_t *datosI, int longitud);
float calcularRMS(int16_t *datos, int longitud);
void calcular(int16_t *datosV, int16_t *datosI, int longitud);

int main()
{
    bt.baud(9600);
    Ticker timerCaptura;
    Ticker timerVisualizacion;
    //Ticker timerVisualizacion_blu;
    timerCaptura.attach_us(&captura,400);
    timerVisualizacion.attach(&visualizacion,1.0);
    //timerVisualizacion_blu.attach(&visualizacion_blu,1.0);
    boton.rise(&cambiar);
    while(1) {
        if(flag) {
            if(bufferActivo) {
                calcular(vectores.vTensionA,vectores.vIntensidadA,muestras);
            } else {
                calcular(vectores.vTensionB,vectores.vIntensidadB,muestras);
            }
            flag=0;
        }
    }
}


void captura()
{

    int16_t medidaTension=(int16_t)(tension.read_u16()^0x8000);
    int16_t medidaIntensidad=(int16_t)(intensidad.read_u16()^0x8000);
    int16_t medidaOffset=(int16_t)(adcMedio.read_u16()^0x8000);
    int16_t medidaTensionSinOffset=medidaTension-medidaOffset;
    int16_t medidaIntensidadSinOffset=medidaIntensidad-medidaOffset;
    //lectura señales

    // printf("V = %.2f [V]",x);
    // printf("I = %.2f [A]",y);
    /*
     float datotension = 1.11*(650.5382387*x-325.2691193);
     float datointensidad = 1.61*(18.18*y-9.09);
     */
    //uint16_t dato=adc_in.read_u16();

    if(bufferActivo) {
        vectores.vTensionB[contador] = medidaTensionSinOffset;
        vectores.vIntensidadB[contador] = medidaIntensidadSinOffset;
    } else {
        vectores.vTensionA[contador]=medidaTensionSinOffset;
        vectores.vIntensidadA[contador]=medidaIntensidadSinOffset;
    }

    // dac_out.write_u16(dato);

    contador++;

    if(contador==muestras) {
        flag = 1;
        contador = 0;
        if(bufferActivo) {
            bufferActivo=0;
        } else {
            bufferActivo=1;
        }

        //bufferActivo=!bufferActivo;
    }

}
/*
void visualizacion_blu()
{
        
       //If (bt.available() > 0)     
   {
      inputdata = bt.read();       
      if(inputdata == '0')
      {
         Serialbt.print("Vrms\n %.2f [V]",medidas.Vrms);
      }
        
      else if(inputdata == '1') 
      {     
         Serialbt.print("Irms\n %.2f [A]",medidas.Irms);
      }
            else if(inputdata == '2') 
      {     
         Serialbt.print("P\n %.2f [W]",medidas.potenciaActiva);
      }
            else if(inputdata == '3') 
      {     
         Serialbt.print("Q\n %.2f [VAr]",medidas.potenciaReactiva);
      }
            else if(inputdata == '4') 
      {     
         Serialbt.print("S\n %.2f [VA]",medidas.potenciaAparente);
      }
            else if(inputdata == '5') 
      {     
         Serialbt.print("Pac\n %.2f [W]",medidas.potenciaActivaAC);
      }
            else if(inputdata == '6') 
      {     
         Serialbt.print("Qac\n %.2f [W]",medidas.potenciaReactivaAC);
      }
            else if(inputdata == '7') 
      {     
         Serialbt.print("FdP\n %.8f",medidas.factorDePotencia);
      }
   }
   
}
*/

void visualizacion()
{
    printf("Vrms = %.2f [V]\n",medidas.Vrms);
    printf("Irms = %.2f [A]\n",medidas.Irms);
    printf("P = %.2f [W]\n",medidas.potenciaActiva);
    printf("Q = %.2f [VAr]\n",medidas.potenciaReactiva);
    printf("S = %.2f [VA]\n",medidas.potenciaAparente);
    printf("Pac = %.2f [W]\n",medidas.potenciaActivaAC);
    printf("Qac = %.2f [W]\n",medidas.potenciaReactivaAC);
    printf("FdP = %.2f\n",medidas.factorDePotencia);
    printf("*******************\n");

    lcd.cls();
    switch (mostrarDato) {
        case 0:
            lcd.printf("Vrms\n %.2f [V]",medidas.Vrms);
            break;
        case 1:
            lcd.printf("Irms\n %.2f [A]",medidas.Irms);
            break;
        case 2:
            lcd.printf("P\n %.2f [W]",medidas.potenciaActiva);
            break;
        case 3:
            lcd.printf("Q\n %.2f [VAr]",medidas.potenciaReactiva);
            break;
        case 4:
            lcd.printf("S\n %.2f [VA]",medidas.potenciaAparente);
            break;
        case 5:
            lcd.printf("Pac\n %.2f [W]",medidas.potenciaActivaAC);
            break;
        case 6:
            lcd.printf("Qac\n %.2f [W]",medidas.potenciaReactivaAC);
            break;
        case 7:
            lcd.printf("FdP\n %.8f",medidas.factorDePotencia);
            break;
            
    }
    bt.printf(" Vrms%.2f [V] \n Irms %.2f [A] \n P %.2f [W]\n Q %.2f [VAr]\n S %.2f [VA]\n Pac %.2f [W]\n Qac %.2f [W]\n FdP %.8f",
    medidas.Vrms,medidas.Irms,medidas.potenciaActiva,medidas.potenciaReactiva,medidas.potenciaAparente,medidas.potenciaActivaAC,
    medidas.potenciaReactivaAC,medidas.factorDePotencia);
    //bt.printf("Vrms\n %.2f [V] |Irms\n %.2f [A] |P\n %.2f [W]|Q\n %.2f [VAr]|S\n %.2f [VA]| Pac\n %.2f [W]| Qac\n %.2f [W]| FdP\n %.8f",medidas.Vrms,medidas.Irms,medidas.potenciaActiva,medidas.potenciaReactiva,medidas.potenciaAparente,medidas.potenciaActivaAC,medidas.potenciaReactivaAC,medidas.factorDePotencia);

}

void cambiar()
{
    mostrarDato++;
    if (mostrarDato>7) {
        mostrarDato=0;
    }
}

int eBoton=0;

void calcular(int16_t *datosV, int16_t *datosI, int longitud)
{
    //multiplicar la constante por vrms

    medidas.Vrms = calcularRMS(datosV,longitud)*0,0119968263348874;
    medidas.Irms = calcularRMS(datosI,longitud)*0.000558209361279455;
    medidas.potenciaActiva = calcularP(datosV,datosI,longitud)*0.000008490055907814898;
    medidas.potenciaAparente = medidas.Vrms*medidas.Irms;
    medidas.potenciaReactiva = sqrt(medidas.potenciaAparente*medidas.potenciaAparente-medidas.potenciaActiva*medidas.potenciaActiva);
    medidas.potenciaActivaAC += medidas.potenciaActiva*0.2/3600;//*0.2/3600;          //0.000000277777
    medidas.potenciaReactivaAC += medidas.potenciaReactiva*0.2/3600;           //0.000000277777;
    medidas.factorDePotencia = medidas.potenciaReactiva/medidas.potenciaAparente;
}

float calcularRMS(int16_t *datos, int longitud)
{
    int64_t acumulador=0;
    int32_t producto;
    int i;

    for(i=0; i<longitud; i++) {
        producto=datos[i]*datos[i];
        acumulador += producto;
    }
    float valor = acumulador/longitud  ;
    return sqrt(valor);
}


float calcularP(int16_t *datosV, int16_t *datosI, int longitud)
{
    int64_t acumulador=0;
    int32_t producto;
    int i;

    for(i=0; i<longitud; i++) {
        producto=datosV[i]*datosI[i];
        acumulador += producto;
    }
    float valor = acumulador/longitud  ;
    return valor;
}


