#include "Motor.h"
#include "mbed.h"
#include <stdint.h>

#ifndef MBED_LINEFOLLOWER_H
#define MBED_LINEFOLLOWER_H

class LineFollower{

    public:
    /** Create a Line Follower interface for an IR Sensor Array
    *
    * @param ir1  IR Sensor 1
    * @param ir2  IR Sensor 2
    * @param ir3  IR Sensor 3
    * @param ir4  IR Sensor 4
    * @param ir5  IR Sensor 5
    * @param ir6  IR Sensor 6
    * @param ir7  IR Sensor 7
    * @param ir8  IR Sensor 8
    */   
    LineFollower(PinName ir1, PinName ir2, PinName ir3, PinName ir4,
                PinName ir5, PinName ir6, PinName ir7, PinName ir8);
                
                    
    /** Read the value of a LineFollower object
    * 
    * @return The value of the Sensor
    */                    
    uint8_t read();
    
    /** Follow a line
    * 
    * @param    l left drive motor
    * @param    r  right drive motor
    */                    
    int followLine(Motor l, Motor r);
    
    float analogFollow(Motor l, Motor r, float maxspeed, float sp_adj_mult);
        
    protected:
    /* Constants */
    #define ROTATE_SPEED    100
    
    /* Attributes */
    BusIn array;
    
    float prevLeft;
    float prevRight;
    

};

#endif