#include "LineFollower.h"
#include "Motor.h"
#include "mbed.h"
#include <stdint.h>

    /** Create a Line Follower interface for an IR Sensor Array
    *
    * @param ir1  IR Sensor 1
    * @param ir2  IR Sensor 2
    * @param ir3  IR Sensor 3
    * @param ir4  IR Sensor 4
    * @param ir5  IR Sensor 5
    * @param ir6  IR Sensor 6
    * @param ir7  IR Sensor 7
    * @param ir8  IR Sensor 8
    */   
    LineFollower::LineFollower(PinName ir1, PinName ir2, PinName ir3, PinName ir4,
                PinName ir5, PinName ir6, PinName ir7, PinName ir8):
                array(ir1, ir2, ir3, ir4, ir5, ir6, ir7, ir8)
                {}
                
    /** Read the value of a LineFollower object
    * 
    * @return The value of the Sensor
    */                    
    uint8_t LineFollower::read(){
        return array;
    }
    
    float LineFollower::analogFollow(Motor l, Motor r, float maxspeed, float sp_adj_mult){
        float sum = 0;
        int count = 0;
        for(int i = 0; i < 8; i++)
            if(!(array & (1<<i))){
                sum += (i+1);
                count++;
            }
        if(count == 0 || count == 8) return -1;
        float center = sum/count;
        //Change the sp_adj_mult to change how drastic your adjustments are. 0-1
        float speed_adjust = sp_adj_mult*(center-4.5)/(3.5)*maxspeed;
        //Also, can change maxspeed if the thing is too fast overall. 0-1
        
        if(center > 4.5){
            l.speed(maxspeed - speed_adjust);
            r.speed(maxspeed);
        }
        else if(center < 4.5){
            l.speed(maxspeed);
            r.speed(maxspeed + speed_adjust);
        }
        else{
            l.speed(maxspeed);
            r.speed(maxspeed);
        }
        
        return center;
    }
    
    /** Follow a line
    * 
    * @param    l left drive motor
    * @param    r  right drive motor
    */   
    /*                 
    int LineFollower::followLine(Motor l, Motor r){
           int count = 0;
           for(int i = 0; i<8; i++){
                count += (array&(1<<i))?0:1;  
            }
            
            switch(count){
                
                case 1: if(this->read() == 0x7F){
                            l.speed(-(0.75 * maxspeed));
                            r.speed(maxspeed);
                        }
                        else if(this->read() == 0xFE){
                            l.speed(maxspeed);
                            r.speed(-(0.75 * maxspeed));
                        }
                        break;
                        
                case 2: if(this->read() == 0xE7){
                            l.speed(maxspeed);
                            r.speed(maxspeed);
                        }
                        else if(this->read() == 0x3F){
                            l.speed(-(0.5 * maxspeed));
                            r.speed(maxspeed);
                        }
                        else if(this->read() == 0xFC){
                            l.speed(maxspeed);
                            r.speed(-(0.5 * maxspeed));
                        }
                        else if(this->read() == 0x9F){
                            l.speed(0);
                            r.speed(maxspeed);
                        }
                        else if(this->read() == 0xF9){
                            l.speed(maxspeed);
                            r.speed(0);
                        }
                        else if(this->read() == 0xCF){
                            l.speed(0.5*maxspeed);
                            r.speed(maxspeed);
                        }
                        else if(this->read() == 0xF3){
                            l.speed(maxspeed);
                            r.speed(0.5*maxspeed);
                        }
                        break;
                        
                case 3: if(this->read() == 0x1F){
                            l.speed(-(0.25*maxspeed));
                            r.speed(maxspeed);
                        }
                        else if(this->read() == 0xF8){
                            l.speed(maxspeed);
                            r.speed(-(0.25*maxspeed));
                        }
                        else if(this->read() == 0x8F){
                            l.speed(0.25*maxspeed);
                            r.speed(maxspeed);
                        }
                        else if(this->read() == 0xF1){
                            l.speed(maxspeed);
                            r.speed(0.25*maxspeed);
                        }
                        else if(this->read() == 0xC7){
                            l.speed(0.5*maxspeed);
                            r.speed(maxspeed);
                        }
                        else if(this->read() == 0xE3){
                            l.speed(maxspeed);
                            r.speed(0.5*maxspeed);
                        }
                        break;
              default:  break;
              
            }
            
            
            
            return count;
    }
    */