#ifndef NODE_CFG_H_
#define NODE_CFG_H_

/************** NODE PROFILE SELECTION ***********************/

//Which Radio
#define NODE_6LOWPAN    0
#define NODE_ETHERNET   1

//Which Sensors
#define     NODE_SENSOR_STATION         1       // use K64F platform. Base sensor platform. Includes Microphone, temperature.
#define     NODE_HEIGHT_STATION         0       // use K64F platform. This include door height sensor
#define     NODE_KIOSK_STATION          1       // use K64F platform. This includes kiosk presence sensor
#define     NODE_DOOR_TRIP_STATION      0       // use K64F platform. This includes door tripwire sensor
#define     NODE_PIR_STATION            0       // use K64F platform. This includes pir motion sensor

#define     HEART_BEAT                  1       // For debug...

/*************** NODE PROFILE CONFIGURATION  *****************/

/** CES NODE DEFINITIONS **/

#if NODE_6LOWPAN
//6LoWPAN Sensors...
#define ENDPOINT_TYPE       {"mbed-sensor-6LoWPAN"}

//#define NODE_SHORT_ADDRESS          01                  //mbed Meeting Room
//#define NODE_NAME                   "mbed-sensor-mbed"
//#define NODE_SHORT_ADDRESS          02                  //Cortex Meeting Room
//#define NODE_NAME                   "mbed-sensor-Cortex"
//#define NODE_SHORT_ADDRESS          03                  //Artisan Meeting Room
//#define NODE_NAME                   "mbed-sensor-Artisan"
//#define NODE_SHORT_ADDRESS          04                  //Mali Meeting Room
//#define NODE_NAME                   "mbed-sensor-Mali"
//#define NODE_SHORT_ADDRESS          05                  //Casual Seating Area 1
//#define NODE_NAME                   "mbed-sensor-Casual-1"
//#define NODE_SHORT_ADDRESS          06                  //Casual Seating Area 2
//#define NODE_NAME                   "mbed-sensor-Casual-2"
//#define NODE_SHORT_ADDRESS          07                  //Reception
//#define NODE_NAME                   "mbed-sensor-Reception"

#define GENERATE_MAC_ADDRESS(short) {0,0,6,0x02,0x00,0x00,0x09,0x ## short ## }
#define NODE_MAC_ADDRESS        GENERATE_MAC_ADDRESS(NODE_SHORT_ADDRESS) //{0,0,6,0x02,0x00,0x00,0x09,0x02}

#else
//Ethernet Sensors...
#define ENDPOINT_TYPE       {"mbed-sensor-Ethernet"}

#define NODE_NAME                   "mbed-sensor-demo-eth"
//#define NODE_NAME                   "mbed-sensor-demo-2"
//#define NODE_NAME                   "mbed-sensor-demo-3"
//#define NODE_NAME                   "mbed-sensor-demo-4"  
//#define NODE_NAME                   "mbed-sensor-demo-5"
//#define NODE_NAME                   "mbed-sensor-demo-6"  
//#define NODE_NAME                   "mbed-sensor-stairs"  
//#define NODE_NAME                   "mbed-sensor-reception"


#endif //Node comms Type

#define LIFE_TIME           {"43200"}     //seconds, extra char needed to avoid truncation 12 HOURS


// ****************************************************************************
// Ethernet Config...
#if NODE_ETHERNET
// Ethernet configuration
/* Define this to enable DHCP, otherwise manual address configuration is used */
#define DHCP

/* Manual IP configurations, if DHCP not defined */
#define IP      "192.168.1.100"
#define MASK    "255.255.255.0"
#define GW      "10.45.0.1"
#endif //ETHERNET
// ****************************************************************************



/************** REGISTRATION  PARAMETERS  ************************/
#define RD_UPDATE_PERIOD_MS    300000      // 5 minutes

#define NSP_IP_ADDRESS              "192.168.1.100" //IPv4

#if NODE_6LOWPAN
#define NSP_IP_ADDRESS_BYTES      {0x20, 0x02, 0x0d, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x02, 0x00, 0x01} //IPv6
#else // Not NODE_6LOWPAN
//Default to IPv4
#define NSP_IP_ADDRESS_BYTES        {0xc0, 0xa8, 0x01, 0x64} //IPv4
#endif // NODE_ETHERNET

#endif  // NODE_CFG_H_