#include "mbed.h"

uint8_t lqi_ptr[3] = {'-','-', '-'};
uint8_t lqi_ptr_len = 3;

uint8_t int16_to_string(uint8_t *tmstring, int16_t number)
{
    if(number < 10)
    {
        tmstring[0] = number + '0';
        return 1;
    }
    else if(number < 100)
    {
        tmstring[0] = number/10 + '0';
        tmstring[1] = (number%10) + '0';
        return 2;
    }
    else if(number < 1000)
    {
        tmstring[0] = number/100 + '0';
        number %= 100;
        tmstring[1] = number/10 + '0';
        tmstring[2] = (number%10) + '0';
        return 3;
    }
    else if(number < 10000)
    {
        tmstring[1] = number/1000 + '0';
        number %= 1000;
        tmstring[1] = number/100 + '0';
        number %= 100;
        tmstring[2] = number/10 + '0';
        tmstring[3] = (number%10) + '0';
        return 4;
    }
    else
    {
        tmstring[0] = number/10000 + '0';
        number %= 10000;
        tmstring[1] = number/1000 + '0';
        number %= 1000;
        tmstring[2] = number/100 + '0';
        number %= 100;
        tmstring[3] = number/10 + '0';
        tmstring[4] = (number%10) + '0';
        return 5;
    }   
}

void create_lqi_resource(uint8_t lqi_value)
{
    lqi_ptr_len = int16_to_string(lqi_ptr, (int16_t) (lqi_value));
}

void* own_alloc(uint16_t size)
{
    if(size)
    {
        void * ptr = (void*) malloc(size);
        //void * ptr = (void __data16*) __data16_malloc(size);
        if(ptr)
        {
            memset(ptr, 0, size);
            return ptr;
        }
    }
#ifdef DEBUG
                debug("Mem failed: ");
                debug_int(size);
                debug("\r\n");
#endif  
    return 0;
}

void own_free(void *ptr)
{
    if(ptr)
    {
        free(ptr);
        //__data16_free((void __data16*)ptr);
    }
}
