#ifndef SENSOR_CTL_H_
#define SENSOR_CTL_H_
/** Defines sensor control functionality for CES Instrumented Booth demonstrations */



/*******  Sensor Timer/Debounce Periods (ms) **********/
#define TEMPERATURE_REPORT_PERIOD_MS   60000       // Every Minute
#define SOUND_SAMPLE_PERIOD_MS           100       // Every 100 ms
#define SOUND_REPORT_PERIOD_MS         10000       // Every 10 seconds
#define DOOR_HEIGHT_PERIOD_MS             50       // Every 50 ms
#define MOTION_REPORT_PERIOD_MS          250       // Every Quarter Second.
#define DOOR_TRIP_REPORT_PERIOD_MS       250       // Every quarter second.
#define KIOSK_REPORT_PERIOD_MS          1000       // Every Second
#define ACCELEROMETER_PERIOD_MS          200       // Every 200ms


#define DOOR_SENSOR_DEBOUNCE_MS     1000
#define KIOSK_SENSOR_DEBOUNCE_MS    10000
#define PIR_SENSOR_DEBOUNCE_MS      300000 // Five Minutes


//Externally visible values.
extern float    current_temperature_value;
extern float    current_ambient_noise_value;
extern float    current_height_value;
extern bool     current_presence_value;         //Either from Kiosk or PIR
extern bool     current_door_trip_value;
extern bool     current_accelerometer_value;



//Initialisation
void init_sensors();

//Handle timers/interrupts/etc
void handle_temperature_report_timer();
void handle_microphone_sample_timer();
void handle_microphone_report_timer();
void handle_motion_report_timer();
void handle_door_height_sample_timer();
void handle_door_trip_report_timer();
void handle_kiosk_report_timer();
void handle_accelerometer_report_timer();

#endif  // SENSOR_CTL_H_