#include "mbed.h"
#include "nsdl_support.h"
#include "nsdl_dbg.h"

#include "node_cfg.h"

#include "door_trip.h"
#include "height.h"
#include "presence_resource.h"
#include "temperature.h"
#include "sound_level.h"


// ****************************************************************************
// Configuration section

// NSP configuration
/* Change this IP address to that of your NanoService Platform installation */
uint8_t NSP_address_bytes[] = NSP_IP_ADDRESS_BYTES;

uint8_t endpoint_name[30] = NODE_NAME;
uint8_t ep_type[] = ENDPOINT_TYPE;
uint8_t lifetime_ptr[] = LIFE_TIME;  

// ****************************************************************************
// Resource creation

static int create_resources()
{
    sn_nsdl_resource_info_s *resource_ptr = NULL;
    sn_nsdl_ep_parameters_s *endpoint_ptr = NULL;
    
    NSDL_DEBUG("Creating resources");

    /* Create resources */
    resource_ptr = (sn_nsdl_resource_info_s*)nsdl_alloc(sizeof(sn_nsdl_resource_info_s));
    if(!resource_ptr)
        return 0;
    memset(resource_ptr, 0, sizeof(sn_nsdl_resource_info_s));

    resource_ptr->resource_parameters_ptr = (sn_nsdl_resource_parameters_s*)nsdl_alloc(sizeof(sn_nsdl_resource_parameters_s));
    if(!resource_ptr->resource_parameters_ptr)
    {
        nsdl_free(resource_ptr);
        return 0;
    }
    memset(resource_ptr->resource_parameters_ptr, 0, sizeof(sn_nsdl_resource_parameters_s));

    // Static resources
    nsdl_create_static_resource(resource_ptr, sizeof("dev/mfg")-1, (uint8_t*) "dev/mfg", 0, 0,  (uint8_t*) "ARM mbed", sizeof("ARM mbed")-1);
    nsdl_create_static_resource(resource_ptr, sizeof("dev/mdl")-1, (uint8_t*) "dev/mdl", 0, 0,  (uint8_t*) "Ethernet node", sizeof("Ethernet node")-1);

    // Dynamic resources
#if NODE_SENSOR_STATION    
    create_temperature_resource(resource_ptr); 
    create_sound_level_resource(resource_ptr);
    #if NODE_KIOSK_STATION
    create_presence_resource(resource_ptr);
    #elif NODE_HEIGHT_STATION
    create_height_resource(resource_ptr);
    #endif
    #if NODE_DOOR_TRIP_STATION
    create_door_trip_resource(resource_ptr);
    #endif
    #if NODE_PIR_STATION
    create_presence_resource(resource_ptr);
    #endif
#endif   

        /* Register with NSP */
//    endpoint_ptr = nsdl_init_register_endpoint(endpoint_ptr, (uint8_t*)endpoint_name, ep_type, lifetime_ptr);
//    if(sn_nsdl_register_endpoint(endpoint_ptr) != 0)
//        printf("NSP registering failed\r\n");
//    else
//        printf("NSP registering OK\r\n");
//    nsdl_clean_register_endpoint(&endpoint_ptr);

    nsdl_free(resource_ptr->resource_parameters_ptr);
    nsdl_free(resource_ptr);
    return 1;
}

// ****************************************************************************
// Program entry point
// this modified to startup as an option in the Wi-Go demo

void nsdl_run()
{

    NSDL_DEBUG("ARM NSP Init\r\n");
    
    // Initialize NSDL stack
    nsdl_init();
     
    // Create NSDL resources
    create_resources();
    
}
