/**************************************
* Bluetooth Controller double key press library
* Author: Shalaj Lawania.
**************************************/

#include "mbed.h"

void display_move(int b, int c);
void two_button_sequence(char p);
void two_button_instant(char n);

/**********************************************************************
* two_buttons(): determines if two buttons are pressed at once, or 
* one button is pressed and then another one is pressed while the first
* one is still pressed                                                                                             
**********************************************************************/

void two_buttons(char l)
{
    press_time_stop();
    
    if(one_pressed == 0) {
        two_button_instant(l);
    } else {
        two_button_sequence(l);
    }
}

/************************************************************************
* two_button_sequence(): If two buttons are pressed, with the second one
* pressed while the first one was pressed earlier, this method is called
* stores and displays move, starts press_time           
* sets two_pressed, resets one_pressed                                                                           
************************************************************************/

void two_button_sequence(char p)
{
    one_pressed = 0; two_pressed = 1;
    press_time.start();
    move_type[i] = p;
    display_move(p, i);
    i++;
}

/************************************************************************
* two_button_instant(): If two buttons are pressed together instantly 
* this method is called. Stores and displays move, starts press_time  
* sets two_pressed                                                                                    
************************************************************************/

void two_button_instant(char n)
{
    two_pressed = 1;
    press_time.start();
    move_type[i] = n;
    display_move(n, i);
    pc.printf(" instant");
    i++;
}

/************************************************************************
* two_button_controller(): Once one of two buttons (or both) are released
* this method is called. Resets two_pressed, stops, stores and displays 
* press_time                                                                    
************************************************************************/

void two_button_controller()
{
    press_time.stop();
    two_pressed = 0;
    press_times[j] = press_time.read_ms();
    subtractor = press_times[j];
    pc.printf("\n\r Double Key Press Time: %d", press_times[j]);
    j++;
}
