/**************************************
* Bluetooth Controller single key press library
* Author: Shalaj Lawania.
**************************************/

#include "mbed.h"
#include "Timers.h"

/*************************************************
* Bluefruit E-Z keys assigned to LPC1786 GPIO pins
**************************************************/

DigitalOut up_key (p30);
DigitalOut down_key (p29);
DigitalOut right_key (p28);
DigitalOut left_key (p27);
DigitalOut enter_key(p5);
DigitalOut space_key(p6);
DigitalOut W_key(p22);
DigitalOut S_key(p11);
DigitalOut A_key(p23);
DigitalOut D_key(p8);
DigitalOut one_key(p13);
DigitalOut two_key(p14 );

Serial bluefruit(p9, p10);
InterruptIn playI(p25);

/************************************************************************
* move_type array: Stores a unique id for each move, i.e 1 for Up, 2 for Down
************************************************************************/

char move_type[400]; //change index to increase recorded moves

char key_ID [9];
unsigned int i, k, z = 0;
unsigned int one_pressed, two_pressed = 0;
unsigned int subtractor;

void display_move(int b, int c);
void play_time_stop();
void press_time_stop();
void two_button_controller();
void one_button_controller(char m);

/*************************************************
* setup() switches all play keys to off initially
*************************************************/

void setup()
{
    up_key = 1; down_key = 1; left_key = 1; right_key = 1; W_key = 1; S_key = 1; A_key = 1; D_key = 1; enter_key = 1; space_key = 1; one_key = 1; two_key = 1;
}

/***********************************************************
* Overloaded setup() switches all the keys off 
* except the ones involved in the move z references
* Used to provide continuous playback for double key presses
***********************************************************/

void setup(char z)
{
    //if (z != 1 || z != 5 || z != 6 || z != 7 || z != 26 || z != 30 || z != 34 || z != 44) {
    up_key = 1;
    //}
    //if (z != 2 || z != 6 || z != 8 || z != 9 || z != 29 || z != 31 || z != 35 || z != 45) {
    down_key = 1;
    //}
    //if (z != 3 || z != 7 || z != 9 || z != 10 || z != 28 || z != 33 || z != 36 || z != 47) {
    left_key = 1;
    //}
    //if (z != 4 || z != 5 || z != 8 || z != 10 || z != 27 || z != 32 || z != 37 || z != 46) {
    right_key = 1;
    //}
    //if (z != 11 || z != 19 || z != 20 || z != 23 || z != 38 || z != 48) {
    W_key = 1;
    //}
    //if (z != 12 || z != 21 || z != 22 || z != 23 || z != 39 || z != 49) {
    S_key = 1;
    //}
    //if (z != 13 || z != 19 || z != 21 || z != 24 || z != 40 || z != 50) {
    A_key = 1;
    //}
    //if (z != 14 || z != 20 || z != 22 || z != 24 || z != 41 || z != 51) {
    D_key = 1;
    //}
    //if (z != 16 || z != 30 || z != 31 || z != 32 || z != 33 || z != 43 || z != 52) {
    enter_key = 1;
    //}
    //if (z != 15 || z != 26 || z != 27 || z != 28 || z != 29 || z != 42 || z != 53) {
    space_key = 1;
    //}
    //if (z != 17 || z != 25 || z != 34 || z != 35 || z != 36 || z != 37 || z != 38 || z != 39 || z != 40 || z != 41 || z != 42 || z != 43) {
    one_key = 1;
    //}
    //if (z != 18 || z != 25 || z != 44 || z != 45 || z != 46 || z != 47 || z != 48 || z != 49 || z != 50 || z != 51 || z != 52 || z != 53) {
    two_key = 1;
    //}
}

/***********************************************************************
* one_button(): If just one button is pressed call one_button_controller
* call two_button_controller if more than one is pressed                                                                                                
***********************************************************************/

void one_button(char q)
{
    if (two_pressed) {
        two_button_controller();
    }
    one_button_controller(q);
}

/*************************************************************
* one_button_controller(): Sets one_pressed, resets press_time 
* saves the move into move_type array 
* stops, saves and resets wait_time                                                                                           
*************************************************************/

void one_button_controller(char m)
{
    one_pressed = 1;
    press_time.reset(); press_time.start();
    move_type[i] = m;
    display_move(m, i);
    wait_time.stop();
    if (subtractor > 0) {
        wait_times[i] = 0;
    } else {
        wait_times[i] = wait_time.read_ms();
    }
    pc.printf("\n\r Gap Time: %d", wait_times[i]);
    wait_time.reset();
    i++; subtractor = 0;
}