/*****************************************************************************************************
* Bluetooth Controller for Android App Analysis
* Author: Shalaj Lawania.
* 
* This Bluetooth Remote uses a Bluefruit E-Z Key along with an LPC1768 board to emulate
* the functioning of a game controller along with one additional feature - it can record
* and play back user input for a particular game.
*
* The default key map for Bluefruit E-Z Key is:
* #0 - Up Arrow
* #1 - Down Arrow
* #2 - Left Arrow
* #3 - Right Arrow
* #4 - Return
* #5 - Space
* #6 - the number '1'
* #7 - the number '2'
* #8 - lowercase 'w'
* #9 - lowercase 'a'
* #10 - lowercase 's'
* #11 - lowercase 'd'
*
* All keys can be remapped via USB or wirelessly via Bluetooth. The possible key combinations
* include Shift, Esc, Backspace, VolumeUp, Play/Pause along with Cursor coordinates and clicks
* Keys can also be represented as a combination i.e. #0 Up + Space, #1 Mouse X +150 + Left Button Click 
******************************************************************************************************/

#include "mbed.h"
#include "string.h"
#include "one_button.h"
#include "two_buttons.h"
#include "Play.h"
#include "stdio.h"

int reset = 0;

int main()
{
    pc.printf("\n\r *****");
    pc.printf("\n\r START");
    pc.printf("\n\r ***** \n\r");
    setup(0);
    
    playI.rise(&play); //Play button configured as interrupt
    
    while(1) {
        
        if(two_pressed == 0 && one_pressed == 0) {
            wait_time.start();
        }
        
        if (bluefruit.readable()) {
            bluefruit.gets(key_ID, 9);
            //pc.puts(key_ID);  //displays string value sent from Bluefruit E-Z Key to LPC1768

            if (playflag == 0) {
                string_comparator(key_ID);
            } else {
                // if the play button was pressed do nothing with next key
                if (reset < 2) {
                    reset++;
                } else {
                    playflag = 0;
                    reset = 0;
                }
            }
            
        }
    }
}