/**********************************************
* Bluetooth Controller Timers handling library
* Author: Shalaj Lawania.
**********************************************/

#include "mbed.h"

/******************************************************************************
* Timer wait_time: Record time no key is pressed - Wait Time
* Timer press_time: Record time a key is kept pressed - Press Time
* Timer play_time: Dummy timer to mimic press_time when sequence is played back
******************************************************************************/

Timer wait_time, press_time, play_time;

/************************************************************
* wait_times array: Stores Timer wait_time values for each move
* press_times array: Stores Timer press_time values for each move 
************************************************************/

unsigned long long wait_times[400]; //change index to increase recorded wait time
unsigned long long press_times[400]; //change index to increase recorded press time

Serial pc(USBTX, USBRX);

unsigned int j = 0;
unsigned long long display_play_time = 0;

/******************************************************************************
* press_time_stop() stops and resets the press_time timer that is recording the
* the amount of time a key is pressed. The value is stored in the press_times array
******************************************************************************/

void press_time_stop()
{
    press_time.stop();
    if(press_time.read_ms() > 0) {
        press_times[j] = press_time.read_ms();
        pc.printf("\n\r Press Time: %d \n", press_times[j]);
    }
    press_time.reset();
    j++;
}

/************************************************************************
* play_time_stop() stops and resets the play_time timer that is recording
* time taken to play back a move. Ideally play_time should be equal
* to the press_time 
************************************************************************/

void play_time_stop()
{
    play_time.stop();
    display_play_time = play_time.read_ms();
    if (display_play_time != 0) {
    pc.printf("\n\r Play Time: %d \n", display_play_time);
    }
    play_time.reset();
}