/****************************************************
* Bluetooth Controller Play function handling library
* Author: Shalaj Lawania.
****************************************************/

#include "mbed.h"
#include "Controller.h"

void play_time_stop();
void moves_selector(char p);
void read_file();
void save_file();

int zzz = 0;

/**********************************************************************
* play(): Waits the amount of time equal to the value stored in wait_times[]
* selects the move to play back using move_selector()                                                                                         
**********************************************************************/

void play()
{
    wait_time.stop(); wait_time.reset();
    playflag = 1;
    
    pc.printf("\n\r ****");
    pc.printf("\n\r PLAY");
    pc.printf("\n\r **** \n");
    
    if (i > zzz && i > 1) {
        zzz = i;
        pc.printf("\n\r New Moves recorded");
        save_file();
        read_file();
    } else {
        pc.printf("\n\r Reading file");
        read_file();
    }
    
    //Eliminate 0s presses - removed on adding to file instead
    /*for (k = 0; k < j; k++) { 
        if (press_times[k] == 0) {
            for (int z = k; z < j; z++) {
                press_times[z] = press_times[z+1];
            }
            j--;
        }
    }*/
    
    // Play out moves
    for(k = 0; k <= s; k++) {
        wait_ms(wait_times[k]);
        display_move(move_type[k], k);
        pc.printf("\n\r Wait Time: %d", wait_times[k]);
        moves_selector(move_type[k]);
    }
    
    pc.printf("\n\r ****");
    pc.printf("\n\r DONE");
    pc.printf("\n\r **** \n");
    setup(0);
}


/*****************************************************************
* moves_selector(): plays the move required for the amount of time
* equal to the value stored in press_times[]                                                                                    
*****************************************************************/

void moves_selector(char p)
{   
    play_time.start();
    
    switch (p) {
        
        case 1:
            while(play_time.read_ms() < press_times[k]) {
                up_key = 0;
            }
            up_key = 1;
            break;
        
        case 2:
            while(play_time.read_ms() < press_times[k]) {
                down_key = 0;
            }
            down_key = 1;
            break;
        
        case 3:
            while(play_time.read_ms() < press_times[k]) {
                left_key = 0;
            }
            left_key = 1;
            break;

        case 4:
            play_time.start();
            while(play_time.read_ms() < press_times[k]) {
                right_key = 0;
            }
            right_key = 1;
            play_time_stop();
            break;
            
        case 5:
            while(play_time.read_ms() < press_times[k]) {
                up_key = 0; right_key = 0;
            }
            up_key = 1; right_key = 1;
            break;
            
        case 6:
            while(play_time.read_ms() < press_times[k]) {
                up_key = 0; down_key = 0;
            }
            up_key = 1; down_key = 1;
            break;
            
        case 7:
            while(play_time.read_ms() < press_times[k]) {
                up_key = 0; left_key = 0;
            }
            up_key = 1; left_key = 1;
            break;
        
        case 8:
            while(play_time.read_ms() < press_times[k]) {
                down_key = 0;
                right_key = 0;
            }
            down_key = 1; right_key = 1;
            break;
       
        case 9:
            while(play_time.read_ms() < press_times[k]) {
                down_key = 0; left_key = 0;
            }
            down_key = 1; left_key = 1;
            break;
        
        case 10:
            while(play_time.read_ms() < press_times[k]) {
                right_key = 0; left_key = 0;
            }
            right_key = 1; left_key = 1;
            break;

        case 11:
            while(play_time.read_ms() < press_times[k]) {
                W_key = 0;
            }
            W_key = 1;
            break;

        case 12:
            while(play_time.read_ms() < press_times[k]) {
                S_key = 0;
            }
            S_key = 1;
            break;

        case 13:
            while(play_time.read_ms() < press_times[k]) {
                A_key = 0;
            }
            A_key = 1;
            break;

        case 14:
            while(play_time.read_ms() < press_times[k]) {
                D_key = 0;
            }
            D_key = 1;
            break;

        case 15:
            while(play_time.read_ms() < press_times[k]) {
                space_key = 0;
            }
            space_key = 1;
            break;

        case 16:
            while(play_time.read_ms() < press_times[k]) {
                enter_key = 0;
            }
            enter_key = 1;
            break;

        case 17:
            while(play_time.read_ms() < press_times[k]) {
                one_key = 0;
            }
            one_key = 1;
            break;

        case 18:
            while(play_time.read_ms() < press_times[k]) {
                two_key = 0;
            }
            two_key = 1;;
            break;

        case 19:
            while(play_time.read_ms() < press_times[k]) {
                W_key = 0; A_key = 0;
            }
            W_key = 1; A_key = 1;
            break;

        case 20:
            while(play_time.read_ms() < press_times[k]) {
                W_key = 0; D_key = 0;
            }
            W_key = 1; D_key = 1;
            break;

        case 21:
            while(play_time.read_ms() < press_times[k]) {
                S_key = 0; A_key = 0;
            }
            S_key = 1; A_key = 1;
            break;

        case 22:
            while(play_time.read_ms() < press_times[k]) {
                S_key = 0; D_key = 0;
            }
            S_key = 1; D_key = 1;
            break;

        case 23:
            while(play_time.read_ms() < press_times[k]) {
                W_key = 0; S_key = 0;
            }
            W_key = 1; S_key = 1;
            break;

        case 24:
            while(play_time.read_ms() < press_times[k]) {
                A_key = 0; D_key = 0;
            }
            A_key = 1; D_key = 1;
            break;

        case 25:
            while(play_time.read_ms() < press_times[k]) {
                one_key = 0; two_key = 0;
            }
            one_key = 1; two_key = 1;
            break;

        case 26:
            while(play_time.read_ms() < press_times[k]) {
                up_key = 0; space_key = 0;
            }
            up_key = 1; space_key = 1;
            break;

        case 27:
            while(play_time.read_ms() < press_times[k]) {
                right_key = 0; space_key = 0;
            }
            right_key = 1; space_key = 1;
            break;

        case 28:
            while(play_time.read_ms() < press_times[k]) {
                space_key = 0; left_key = 0;
            }
            space_key = 1; left_key = 1;
            break;

        case 29:
            while(play_time.read_ms() < press_times[k]) {
                down_key = 0; space_key = 0;
            }
            down_key = 1; space_key = 1;
            break;

        case 30:
            while(play_time.read_ms() < press_times[k]) {
                up_key = 0; enter_key = 0;
            }
            up_key = 1; enter_key = 1;
            break;

        case 31:
            while(play_time.read_ms() < press_times[k]) {
                down_key = 0; enter_key = 0;
            }
            down_key = 1; enter_key = 1;
            break;

        case 32:
            while(play_time.read_ms() < press_times[k]) {
                right_key = 0; enter_key = 0;
            }
            right_key = 1; enter_key = 1;
            break;

        case 33:
            while(play_time.read_ms() < press_times[k]) {
                enter_key = 0; left_key = 0;
            }
            left_key = 1; enter_key = 1;
            break;

        case 34:
            while(play_time.read_ms() < press_times[k]) {
                one_key = 0; up_key = 0;
            }
            one_key = 1; up_key = 1;
            break;

        case 35:
            while(play_time.read_ms() < press_times[k]) {
                one_key = 0; down_key = 0;
            }
            one_key = 1; down_key = 1;
            break;

        case 36:
            while(play_time.read_ms() < press_times[k]) {
                one_key = 0; left_key = 0;
            }
            one_key = 1; left_key = 1;
            break;

        case 37:
            while(play_time.read_ms() < press_times[k]) {
                one_key = 0; right_key = 0;
            }
            one_key = 1; right_key = 1;
            break;

        case 38:
            while(play_time.read_ms() < press_times[k]) {
                one_key = 0; W_key = 0;
            }
            one_key = 1; W_key = 1;
            break;

        case 39:
            while(play_time.read_ms() < press_times[k]) {
                one_key = 0; S_key = 0;
            }
            one_key = 1; S_key = 1;
            break;

        case 40:
            while(play_time.read_ms() < press_times[k]) {
                one_key = 0; A_key = 0;
            }
            one_key = 1; A_key = 1;
            break;

        case 41:
            while(play_time.read_ms() < press_times[k]) {
                one_key = 0; D_key = 0;
            }
            one_key = 1; D_key = 1;
            break;

        case 42:
            while(play_time.read_ms() < press_times[k]) {
                one_key = 0; space_key = 0;
            }
            one_key = 1; space_key = 1;
            break;

        case 43:
            while(play_time.read_ms() < press_times[k]) {
                enter_key = 0; one_key = 0;
            }
            one_key = 1; enter_key = 1;
            break;

        case 44:
            while(play_time.read_ms() < press_times[k]) {
                two_key = 0; up_key = 0;
            }
            two_key = 1; up_key = 1;
            break;

        case 45:
            while(play_time.read_ms() < press_times[k]) {
                two_key = 0; down_key = 0;
            }
            two_key = 1; down_key = 1;
            break;

        case 46:
            while(play_time.read_ms() < press_times[k]) {
                two_key = 0; right_key = 0;
            }
            two_key = 1; right_key = 1;
            break;

        case 47:
            while(play_time.read_ms() < press_times[k]) {
                two_key = 0; left_key = 0;
            }
            two_key = 1; left_key = 1;
            break;

        case 48:
            while(play_time.read_ms() < press_times[k]) {
                two_key = 0; W_key = 0;
            }
            two_key = 1;  W_key = 1;
            play_time_stop();
            break;

        case 49:
            while(play_time.read_ms() < press_times[k]) {
                two_key = 0; S_key = 0;
            }
            two_key = 1; S_key = 1;
            break;

        case 50:
            while(play_time.read_ms() < press_times[k]) {
                two_key = 0; A_key = 0;
            }
            two_key = 1; A_key = 1;
            break;

        case 51:
            while(play_time.read_ms() < press_times[k]) {
                two_key = 0; D_key = 0;
            }
            two_key = 1; D_key = 1;
            break;

        case 52:
            while(play_time.read_ms() < press_times[k]) {
                enter_key = 0; two_key = 0;
            }
            two_key = 1; enter_key = 1;
            break;

        case 53:
            while(play_time.read_ms() < press_times[k]) {
                two_key = 0; space_key = 0;
            }
            two_key = 1; space_key = 1;
            break;

        default:
            break;
    }
    play_time_stop();
}