/*****************************************
* Bluetooth Remote control methods library
* Author: Shalaj Lawania.
*****************************************/

#include "mbed.h"

/**********************************************************
* LocalFileSystem local declared to save test sequence in a 
* .txt file which can be read by the play() function
**********************************************************/

LocalFileSystem local("local");

int playflag = 0;
int s = 0;
char* keys[54] = { 
    "K 0xFFE", "K 0xFFD", "K 0xFFB", "K 0xFF7", "K 0xFF6", "K 0xFFC", 
    "K 0xFFA", "K 0xFF5", "K 0xFF9", "K 0xFF3", "K 0xEFF", "K 0xBFF",
    "K 0xDFF", "K 0x7FF", "K 0xFDF", "K 0xFEF", "K 0xFBF", "K 0xF7F",
    "K 0xCFF", "K 0x6FF", "K 0x9FF", "K 0x3FF", "K 0xAFF", "K 0x5FF",
    "K 0xF3F", "K 0xFDE", "K 0xFD7", "K 0xFDB", "K 0xFDD", "K 0xFEE",
    "K 0xFED", "K 0xFE7", "K 0xFEB", "K 0xFBE", "K 0xFBD", "K 0xFBB",
    "K 0xFB7", "K 0xEBF", "K 0xBBF", "K 0xDBF", "K 0x7BF", "K 0xF9F",
    "K 0xFAF", "K 0xF7E", "K 0xF7D", "K 0xF77", "K 0xF7B", "K 0xE7F",
    "K 0xB7F", "K 0xD7F", "K 0x77F", "K 0xF6F", "K 0xF5F", "K 0xFFF" };
    
char* names[53] = {
    "Up", "Down", "Left", "Right", "Up + Right", "Up + Down",
    "Up + Left", "Down + Right", "Down + Left", "Right + Left", "W", "S",
    "A", "D", "Space", "Enter", "One", "Two", 
    "W + A", "W + D", "S + A", "S + D", "W + S", "A + D", 
    "One + Two", "Up + Space", "Right + Space", "Left + Space", "Down + Space", "Up + Enter", 
    "Down + Enter", "Right + Enter", "Left + Enter", "One + Up", "One + Down", "One + Left",
    "One + Right", "One + W", "One + S", "One + A", "One + D", "One + Space",
    "One + Enter", "Two + Up", "Two + Down", "Two + Right", "Two + Left", "Two + W",
    "Two + S", "Two + A", "Two + D", "Two + Enter", "Two + Space" /*, K 0xFFF No button */ };
    
/************************************************************
* string_comparator(): Compares the received string from
* Bluefruit E-Z Key to a set of preset substrings that each
* contain a sequence unique to a key or set of keys. A unique 
* value is sent to one_button() or two_buttons() for each key 
* or combination of keys
************************************************************/

void string_comparator(char *b)
{
    for (int k = 1; k < 55; k++) {
        char* c = strstr(b, keys[k-1]);
        // strstr returns null if the substring isn't found
        if (c) { 
            if (k < 5 || k > 10 && k < 19) {
                one_button(k);
            } else if (k == 54) {
                if(one_pressed) {
                    one_pressed = 0;
                    press_time_stop();
                }
                if (two_pressed) {
                    two_button_controller();
                    press_time.reset();
                }
            } else {
                two_buttons(k);
            }
            break;
        }
    }
}

/*************************************************************
* save_file(): Saves the new sequence in a file titled OUT.txt
* saves it in the format 'move_type wait_time press_time' 
*************************************************************/

void save_file()
{   
    int f = 0;
    FILE *fp = fopen("/local/out.txt", "w");
    fseek(fp, 0, SEEK_SET);
    while (f < i) {
        if (press_times[f] != 0) {
            fprintf(fp, "%d \n", move_type[f]);
            fprintf(fp, "%d \n", wait_times[f]);
            fprintf(fp, "%d \n", press_times[f]);
        }
        f++;
    }
    fclose(fp);
}

/*****************************************************************
* read_file(): reads the saved sequence from a file titled OUT.txt
* inteprets the data in the order move_type, wait_time and press_time
* prints the stored values  
*****************************************************************/

void read_file()
{
    pc.printf("\n\r");
    char c;
    char f[6];
    int r = 0, q = 0, t = 0;
    
    s = 0;

    FILE *fp = fopen("/local/out.txt", "r");
    if (fp) {
    fseek(fp, 0, SEEK_SET);
        while (!feof(fp)) {
            c = fgetc(fp);
            if (c != '\n') {
                if (c == ' ') {
                    t++;
                    if (t == 4) {
                        s++;
                        t = 1;
                    }
                    sscanf(f, "%d", &r);
                    switch(t) {
                        case 1:
                            move_type[s] = r;
                            break;
                        case 2:
                            wait_times[s] = (unsigned long long) r;
                            break;
                        case 3:
                            press_times[s] = (unsigned long long) r;
                            break;
                        default:
                            break;
                    }
                    for (int i = 0; i < q; i++) {
                        f[i] = '\0';
                    }
                    q = 0;
                } else {
                    //pc.printf("%c", c);
                    f[q] = c;
                    q++;
                }
            }
        }
        for (int i = 0; i <= s; i++) {
            pc.printf("\n\r %d", move_type[i]);
            pc.printf(" %d", wait_times[i]);
            pc.printf(" %d", press_times[i]);
        }
        pc.printf("\n\r");
        fclose(fp);
    }
}

/***********************************************************
* display_move() displays the type of move depending on the
* unique number assigned to it and also it's position in the
* array
***********************************************************/

void display_move(int b, int c)
{   
    pc.printf("\n\r Move: %s", names[b - 1]);
    pc.printf("\n\r Position: %d", c);
}