#include "mbed.h"
#include "EaEpaper.h"
#include "Arial37x36.h"
#include "graphics.h"

#define epaper_width 264
#define epaper_hight 176
#define line_hight   40
#define text_field   240
#define ASCII_offset 32

int LineWrap(char* buff);
char* BluetoothRecive(void);

char line[4][40];
int  indent[4];

EaEpaper epaper(p19,           // PWR_CTRL
                p20,           // BORDER
                p11,           // DISCHARGE
                p12,           // RESET_DISP
                p13,           // BUSY
                p8 ,           // SSEL
                p26,           // PWM
                p5,p6,p7,      // MOSI,MISO,SCLK
                p28,p27);      // SDA,SCL 
                
DigitalOut  Flash_CS(p25);     //Flash Select
DigitalOut Screen_CS(p8 );     //Screen Select
DigitalOut led      (p23);     //On board LED

Serial Bluetooth(p9, p10);     // tx, rx
Serial Terminal (USBTX, USBRX);// tx, rx

int main() {
    int n, lineNumber;
    Flash_CS =1;
    Screen_CS=0;
    led      =1;
    Bluetooth.baud(115200);
    Terminal .baud(115200);
    
    epaper.cls();                   //Display the logo
    epaper.print_bm(bitmLogo,5,30);
    epaper.write_disp(); 
    
    while(1){
        lineNumber=LineWrap(BluetoothRecive());      //Wait and recive a string. Word wrap the string so that it fits to the screen
        epaper.cls();                                //Clear screen buffer
        epaper.set_font((unsigned char*) Arial37x36);//Set font
        for(n=0;n<lineNumber;n++){
            epaper.locate(indent[n], (epaper_hight-line_hight*(lineNumber-n*2))/2);
            epaper.printf(line[n]);                  //Write to screen buffer
        }
        epaper.write_disp();                         //Display screen buffer
    }
}

char* BluetoothRecive(void){
    int n=0;
    char buff[200];
    while(1){  
        while(!Bluetooth.readable()){} //Waits for char     
        buff[n]=Bluetooth.getc();      //Saves char to array
        if(buff[n]==0){                //Detects end of string
            break;
        }
        n++; 
    }
    return buff;
}

int LineWrap(char* buff){
    int Old_Pix_Length, Pix_Length, Old_Char_Length, Char_Length, end_flag, lineNumber, words, wordCount, Offset;
    end_flag=0;       //used for an end of string case.
    lineNumber=0;
    Offset=0;
    
    while(!end_flag && lineNumber<4){              //Loop for 4 lines or untill the end of string
    
        //===================================================Find the number of words that can fit on a line==================================================
        words     =0;
        Pix_Length=0;
        while(Pix_Length<text_field && !end_flag){ //check the size of strings with increasing word lengths. When the size is larger than the screen then stop
            words++;
            Old_Pix_Length=Pix_Length;             //Save privious values of Pix and Char
            Old_Char_Length=Char_Length;
            Pix_Length =0;
            wordCount  =0;
            Char_Length=0;
            //----------------Find the length of a string with a number of words----------------
            while(wordCount<words && !end_flag){   
                if(buff[Offset+Char_Length]==0){         //Handle with an end of string case
                    if(Pix_Length<text_field){           //Ignore the end of string case if the string is too big to fit on the screen.
                        Old_Pix_Length=Pix_Length;       //Update the Pix and Char lengths
                        Old_Char_Length=Char_Length+1;
                        end_flag=1;                      //Set flag
                    }
                }else{                                   //If its not the end of the string, add on the size of the current char and copy it to the "line" array
                    Pix_Length+=Arial37x36Size[buff[Offset+Char_Length]-ASCII_offset];
                    line[lineNumber][Char_Length]=buff[Offset+Char_Length];
                }
            
                if(buff[Offset+Char_Length]==' '){       //A SPACE indicates the end of a word
                    wordCount++;
                }
                Char_Length++;
            }
            Pix_Length-=Arial37x36Size[' '-ASCII_offset];//Remove the last SPACE from the string length
            //----------------------------------------------------------------------------------
        }
        //====================================================================================================================================================
        
        line[lineNumber][Old_Char_Length-1]='\0';  //Add a NULL char to the end of string
        indent[lineNumber]=(epaper_width-Old_Pix_Length)/2; //Indent so that the string is in the middle of the screen
        
        Offset+=Old_Char_Length;                   //Increment the offset so that the next line continues from the previous line
        lineNumber++;
    }
    
    return lineNumber;
}