#include "mbed.h"
#include "PinDetect.h"
#include "DebounceIn.h"
#include "EthernetInterface.h"

#define ECHO_SERVER_PORT   4547

DigitalOut myled(LED1);

//**********FIRGELLI**********//
DigitalOut extend(PTB9); //extends actuator
DigitalOut retract(PTB2); //retracts actuator
//AnalogIn   ain(PTC10); //pot wiper (no longer needed)
Timer extend_timer;
Timer retract_timer;
void extend_actuator(); //extends actuator
void retract_actuator(); //retracts actuator
//**********FIRGELLI**********//

//**********SCREW**********//
DigitalOut dir(PTD2); 
DigitalOut step(PTD0);
DigitalOut motor_power(PTB3); 
DebounceIn   switch_top(PTC3);       //top limit switch
DebounceIn   switch_bottom(PTC2);    //bottom limit switch 
void motor_power_function(int on_off); //on=1, off=0
void stop_top();
void stop_bottom();
void move_up();
void move_down();
//**********SCREW**********// 

//**********SEAT**********//
//AnalogIn   ain(PTC10); //output from potential divider
//bool sitting = false;
//bool seat_state(); //Check state of seat.  Returns boolean value for the state of the seat (sitting=true, not sitting=false)
//void person_sitting(); //function called if person sits down
//**********SEAT**********//

//**********SYSTEM**********// 
PinDetect reset_switch(PTC16); 
//void reset_system(); //resets system in case of fault
//**********SYSTEM**********//

Serial pc(USBTX, USBRX); // tx, rx

//**********FIRGELLI**********//
void extend_actuator()
{
    pc.printf("extend\r\n");
    extend_timer.start();
    while(extend_timer.read() < 6)
    {
        extend = 1;
        retract = 0;
    }
    extend = 0;
    retract = 0;
    
    extend_timer.stop();
    extend_timer.reset();
}

void retract_actuator()
{
    pc.printf("retract\r\n");
    retract_timer.start();
    while(retract_timer.read() < 6)
    {
        extend = 0;
        retract = 1;
    }
    extend = 0;
    retract = 0;
    
    retract_timer.stop();
    retract_timer.reset();
}
//**********FIRGELLI**********//

//**********SEAT**********//
/*
bool seat_state()
{
    double sitting_feedback = ain.read();
    // 0.01 < sitting_feedback < 0.99 = person sitting
    // 0.01 > sitting_feedback > 0.99 = person not sitting
    if(sitting_feedback > 0.99 || sitting_feedback < 0.01) //(problem with occassionally jumping to 0.00....)
    {
        sitting = false; //no one is sitting, therefore continue as normal
    }
    else
    {
        sitting = false; //person is sitting, therefore stop movement of steering wheel
        //change to true
    }
    
    return sitting;
}

void person_sitting() 
{
    //stop movement of both actuators and add a wait
    pc.printf("person_sitting\r\n");
    step=0;
    motor_power_function(0);
    wait(3); //delay before starting to move again
}
*/
//**********SEAT**********//

//**********SCREW**********// 
void motor_power_function(int on_off) //on=1, off=0
{
    pc.printf("motor_power=%i\r\n", on_off);
    motor_power = on_off;
}

void stop_top()
{
    pc.printf("stop_top\r\n");
    step=0;
    motor_power_function(0);
    wait(0.5);
    extend_actuator(); //extend actuator once the gantry reaches the top
}

void stop_bottom()
{
    pc.printf("stop_bottom\r\n");
    step=0;
    wait(0.1);
    motor_power_function(0);
}

void move_up()
{
    pc.printf("move_up\r\n");
    motor_power_function(1);
    wait(0.1);
    
    //if (seat_state()==false) //seat free
    //{
    while(switch_top != 1)
    {
            //if (seat_state()==false) //check initial state before moving
            //{
        dir=0; //0 is up
        step=1;
        wait(0.0009); //0.0009 is min. wait
        step=0;
        wait(0.0009);
            //}
            //else
            //{
            //    person_sitting(); //stop movement
            //}
    }
    //}
    stop_top();
}

void move_down()
{
    pc.printf("move_down\r\n");
    retract_actuator(); //retract actuator before gantry moves down
    motor_power_function(1);
    wait(0.1);
    
    //if (seat_state()==false) //seat free
    //{
    while(switch_bottom != 1)
    {
            //if (seat_state()==false) //check initial state before moving
            //{
        dir=1; //1 is down
        step=1;
        wait(0.0009); 
        step=0;
        wait(0.0009);
            //}
        //}
    }
    stop_bottom();
}

//**********SCREW**********// 

int main() {
    reset_switch.mode(PullDown);
    reset_switch.attach_asserted(&NVIC_SystemReset);
    reset_switch.setSampleFrequency();
    
    switch_top.mode(PullDown);
    switch_bottom.mode(PullDown);
      
    wait(0.01);//delay for pullups
    
    motor_power_function(0); //start off with motor off

    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("\nServer IP Address is %s\n", eth.getIPAddress());
    
    UDPSocket server;
    server.bind(ECHO_SERVER_PORT);
    
    Endpoint client;
    char buffer[256];
    char state_buffer[] = "{\"name\":\"steering\"}";
    int state_buffer_size = strlen(state_buffer);
    char deploy_buffer[] = "{\"name\":\"steering\",\"state\":\"deployed\"}";
    int deploy_buffer_size = strlen(deploy_buffer);
    char retract_buffer[] = "{\"name\":\"steering\",\"state\":\"retracted\"}";
    int retract_buffer_size = strlen(retract_buffer);
    
    printf("switch_top = %d\r\n", switch_top.read());
    printf("switch_bottom = %d\r\n", switch_bottom.read());
    
    //initial check to put steering wheel in deployed position
    printf("Checking initial state...\r\n");
    printf("Initial state is ");
    if (switch_top == 1)
    {
        printf("deployed\n");
        extend_actuator(); //Already at the top.  Extend firgelli if need be
    }
    else if (switch_bottom == 1)
    {
        printf("retracted\n"); 
        move_up(); //move up to top for the starting position
    }
    else //neither switch is pressed - midway between states
    {
        printf("midway.  Deploying...\n");
        move_up(); //move up to top (reset)
    }

    while(1) {
        myled = !myled;
        
        printf("\nWaiting for UDP packet...\n");
        int n = server.receiveFrom(client, buffer, sizeof(buffer));
        buffer[n] = '\0';
        
        printf("Received packet from: %s\n", client.get_address());
        printf("Packet contents : '%s'\n",buffer);
        
        if (strcmp(buffer, state_buffer) == 0) //queries current state
        {
            //return 'deployed' or 'retracted' depending on the limit switches
            if (switch_top == 1)
            {
                printf("Sending state (deployed) packet back to client\n");
                server.sendTo(client, deploy_buffer, deploy_buffer_size);
            }
            else if (switch_bottom == 1)
            {
                printf("Sending state (retracted) packet back to client\n");
                server.sendTo(client, retract_buffer, retract_buffer_size);
            }
            else //nothing
            {
            }
        }
        else if (strcmp(buffer, deploy_buffer) == 0) //deploy request
        {
            move_up();
            printf("Sending deployed packet back to client\n");
            server.sendTo(client, buffer, n);
        }
        else if (strcmp(buffer, retract_buffer) == 0) //retract request
        {
            move_down();
            printf("Sending retracted packet back to client\n");
            server.sendTo(client, buffer, n);
        }
        else //invalid request
        {
            printf("Invalid request.  Error.\n");
        }
    }
}
