#include <stdint.h>

#ifndef __DOT_FONT_H__
#define __DOT_FONT_H__


#ifdef __cplusplus
extern "C" {
#endif

#define LOWEST_DOT_CHARACTER_ENCODING ' '
#define HIGHEST_DOT_CHARACTER_ENCODING '~'

typedef struct FONT_CHAR_INFO {
    int          charWidth;
    int          charHeight;
    int          charOffset;
} FONT_CHAR_INFO;

typedef struct FONT_INFO {
    const char              *familyName;
    unsigned int            pointSize;
    unsigned int                     spacing;
    const FONT_CHAR_INFO*   descriptors;
    const uint8_t*          bitmaps;
} FONT_INFO;

extern const FONT_INFO dotfonts[];


extern const FONT_INFO *searchFontFace(const char   *familyName,
                                         unsigned int  pointSize);
#ifdef __cplusplus
}
#endif
                        
#endif /* __DOT_FONT_H__ */