#include <string.h>
#include <stddef.h>

#include "dotfont.h"

extern const uint8_t lucidaConsole_8ptmaps[];
extern const FONT_CHAR_INFO lucidaConsole_8ptDescs[];
extern const uint8_t comicSansMS_10ptBitmaps[];
extern const FONT_CHAR_INFO comicSansMS_10ptDescriptors[];
extern const uint8_t sFSquareHead_8ptBlackBitmaps[];
extern const FONT_CHAR_INFO sFSquareHead_8ptDescriptors[];
extern const uint8_t sFSquareHead_10ptBitmaps[];
extern const uint8_t sFSquareHead_10ptBlackBitmaps[];
extern const FONT_CHAR_INFO sFSquareHead_10ptDescriptors[];
extern const uint8_t sFSquareHead_16ptBitmaps[];
extern const uint8_t sFSquareHead_16ptBlackBitmaps[];
extern const FONT_CHAR_INFO sFSquareHead_16ptDescriptors[];
extern const uint8_t sFSquareHead_20ptBlackBitmaps[];
extern const FONT_CHAR_INFO sFSquareHead_20ptDescriptors[];
extern const uint8_t centuryGothic_9ptBlackBitmaps[];
extern const FONT_CHAR_INFO centuryGothic_9ptDescriptors[];
extern const uint8_t centuryGothic_20ptBlackBitmaps[];
extern const FONT_CHAR_INFO centuryGothic_20ptDescriptors[];
extern const uint8_t centuryGothic_28ptBlackBitmaps[];
extern const FONT_CHAR_INFO centuryGothic_28ptDescriptors[];
extern const uint8_t droidSansMono_9ptBlackBitmaps[];
extern const FONT_CHAR_INFO droidSansMono_9ptDescriptors[];

/* Accumulation of all avaialble fonts */
const FONT_INFO dotfonts[] = {

    {
        "Lucida",
        8,   /* pointSize */
        1,   /* spacing */
        lucidaConsole_8ptDescs,
        lucidaConsole_8ptmaps
    },
    {
        "Comic Sans",
        10,   /* pointSize */
        2,   /* spacing */
        comicSansMS_10ptDescriptors,
        comicSansMS_10ptBitmaps
    },
    {
        "Square Head Black",
        8,   /* pointSize */
        2,   /* spacing */
        sFSquareHead_8ptDescriptors,
        sFSquareHead_8ptBlackBitmaps
    },
    {
        "Square Head",
        10,   /* pointSize */
        2,   /* spacing */
        sFSquareHead_10ptDescriptors,
        sFSquareHead_10ptBitmaps
    },
    {
        "Square Head Black",
        10,   /* pointSize */
        2,   /* spacing */
        sFSquareHead_10ptDescriptors,
        sFSquareHead_10ptBlackBitmaps
    },
    {
        "Square Head",
        16,   /* pointSize */
        2,   /* spacing */
        sFSquareHead_16ptDescriptors,
        sFSquareHead_16ptBitmaps
    },
    {
        "Square Head Black",
        16,   /* pointSize */
        2,   /* spacing */
        sFSquareHead_16ptDescriptors,
        sFSquareHead_16ptBlackBitmaps
    },
    {
        "Square Head Black",
        20,   /* pointSize */
        2,   /* spacing */
        sFSquareHead_20ptDescriptors,
        sFSquareHead_20ptBlackBitmaps
    },
    {
        "Century Gothic Black",
        9,   /* pointSize */
        2,   /* spacing */
        centuryGothic_9ptDescriptors,
        centuryGothic_9ptBlackBitmaps
    },
    {
        "Century Gothic Black",
        20,   /* pointSize */
        2,   /* spacing */
        centuryGothic_20ptDescriptors,
        centuryGothic_20ptBlackBitmaps
    },
    {
        "Century Gothic Black",
        28,   /* pointSize */
        2,   /* spacing */
        centuryGothic_28ptDescriptors,
        centuryGothic_28ptBlackBitmaps
    },
    {
        "Droid Sans Mono Black",
        9,   /* pointSize */
        0,   /* spacing */
        droidSansMono_9ptDescriptors,
        droidSansMono_9ptBlackBitmaps
    },
    

        
    /* sentinel value */
    {
        NULL,
        0,
        NULL,
        NULL
    }
};


const FONT_INFO *
searchFontFace(const char  *familyName,
               unsigned int pointSize)
{
    unsigned fontIndex;

    for (fontIndex = 0; dotfonts[fontIndex].familyName != NULL; fontIndex++) {
        if ((strcmp(dotfonts[fontIndex].familyName, familyName) == 0) &&
            (dotfonts[fontIndex].pointSize == pointSize)) {
            /* found it! */
            return (&dotfonts[fontIndex]);
        }
    }

    return (NULL);
}