/*
 * MurphyBat.h
 *
 *  Created on: 5 Aug 2017
 *      Author: ciscer01
 */

#ifndef MURPHYARM_MURPHYBAT_HPP_
#define MURPHYARM_MURPHYBAT_HPP_

#include <mbed.h>

#define avg_size 1

class MurphyBat {
public:
	MurphyBat(PinName Ir1, PinName Ir2, PinName Ir3, PinName Ir4, PinName Actuator);

	void update();
	static void FireCb(MurphyBat *mb);
	void Fire(void);
private:

	AnalogIn mIr1;
	AnalogIn mIr2;
	AnalogIn mIr3;
	AnalogIn mIr4;
	AnalogIn *BatIrIn[4];
	float BatIrVal[4][avg_size];
	float BatIrTh[4];
	int BatI;
	DigitalOut batActuator;
	Timeout batActuratorTimout;
	bool Fired;
};

#endif /* MURPHYARM_MURPHYBAT_HPP_ */
