/*
 * MurphyBat.cpp
 *
 *  Created on: 5 Aug 2017
 *      Author: ciscer01
 */

#include <MurphyBat.hpp>
#include <mbed.h>

MurphyBat::MurphyBat(PinName Ir1, PinName Ir2, PinName Ir3, PinName Ir4, PinName Actuator):
		mIr1(Ir1),
		mIr2(Ir2),
		mIr3(Ir3),
		mIr4(Ir4),
		BatI(0),
		batActuator(Actuator),
		batActuratorTimout(),
		Fired(false) {

	BatIrIn[0] = &mIr1;
	BatIrIn[1] = &mIr2;
	BatIrIn[2] = &mIr3;
	BatIrIn[3] = &mIr4;
	//BatIrTh[0] = 0.5; 0.5, 0.5, 0.5),
	for (unsigned int i = 0; i < 4; i++){
		for (unsigned int j = 0; j < avg_size; j++) {
			BatIrVal[i][j] = 0;
		}

	}
	BatIrTh[0] = 0.4f - 0.05f;
	BatIrTh[1] = 0.3f - 0.05f;
	BatIrTh[2] = 0.4f - 0.05f;
	BatIrTh[3] = 0.3f - 0.05f;
	batActuator.write(0);
}

void MurphyBat::update() {
	bool fire = false;
	float BatIrAvg[4];
	for (unsigned int i = 0; (i < 4) && (fire == false); i++) {
		//Read the Ir value
		BatIrVal[i][BatI] = BatIrIn[i]->read();
		//start the avarage computation
		BatIrAvg[i] = BatIrVal[i][0];
		for (unsigned int j = 1; j < avg_size; j++) {
			BatIrAvg[i] += BatIrVal[i][j];
		}
		//Compute avarage
		BatIrAvg[i] = BatIrAvg[i] / avg_size;
		if (BatIrVal[i][BatI] > BatIrTh[i]) {
			fire = true;
		}
	}
	BatI = (BatI + 1) % avg_size;
	if (fire) {
		Fire();
	}
}

void MurphyBat::FireCb(MurphyBat *mb){
	mb->Fire();
}

void MurphyBat::Fire(void) {
	if (Fired == false) {
		Fired = true;
		batActuator.write(1);
		batActuratorTimout.attach_us(this,MurphyBat::FireCb, 200000);
	} else {
		Fired = false;
		batActuator.write(0);
		batActuratorTimout.detach();
	}
}
