#include "mbed.h"
//Simple program allowing user to send messages from mbed COM out through UART to another UART COM.
//Andrea Corrado
//Updated 2015/02/23 Eric Gowland - Process on line termination.


Serial pc(USBTX, USBRX); // tx, rx
Serial uart (PTC17, PTC16);

char* PARSE_TRIGGERS = "\r\n";
int PARSE_TRIGGERS_LENGTH = 2;
int MAX_BUFFER_SIZE = 128;

bool isTriggerChar(char c);

int main() {
    char buffer[MAX_BUFFER_SIZE];
    int pos = 0;
    char thisChar = 0;
    while(1) {
        if (pc.readable()) {
            thisChar = pc.getc();
            //Echo
            pc.putc(thisChar);
            //Buffer
            buffer[pos++] = thisChar;
            //If trigger or buffer overflow, output and reset buffer...
            if(pos >= MAX_BUFFER_SIZE || isTriggerChar(thisChar)) {
                pc.printf("\r\n");
                uart.printf("%.*s\r\n", pos, buffer);
                pos = 0;
            }
        }
    }
}

bool isTriggerChar(char c) {
    for (int i = 0; i < PARSE_TRIGGERS_LENGTH; i++) {
        if(c == PARSE_TRIGGERS[i]) {
            return true;
        }
    }
    return false;
}
