#include "mbed.h"
#include "Display.h"

#define Sound 0xA0
#define Servo 0x88

Ticker t;
DigitalIn  Button_Launch(D1);
DigitalIn  Button_Reset (D0);
DigitalIn  Button_Sel1  (D6);
DigitalIn  Button_Sel2  (D7);
DigitalOut LED_Timer    (D3);
DigitalOut LED_Finish   (D4);
DigitalOut LED_Launch   (D5);
DigitalIn  Camera       (D9);

I2C i2c(PTE25, PTE24); // sda, scl



int Time;  //time in 10mS
int timer; //Stores timer mode

int main()
{   
    int count=0;
    
    LED_Launch=1;
    
    wait(0.5);                //Allow other IC's to power up
    DisplayInit();
    
    //--------------------------Timer-----------------------------
    Time=0;                         //reset time.
    timer=Reset;                    //Reset timer
    t.attach(&DisplayUpdate, 0.01); //Set the timer function as a ticker.
    
    /*
    while(1){
        char cmd[4]={1,2,3,4};
        i2c.write(Servo, cmd, 1);
    }
    */
    
    //DisplayScroll("dont crash   get a badge");
    //timer=Reset;
    
    
    while(true){ 
        
        if(!Button_Launch && timer==Start){
            Time+=1000;
            wait(0.2f);
            while(!Button_Launch){}
            wait(0.2f);
        }
        
        if(!Button_Launch && timer==Reset){
            char n='S';
            LED_Launch=0;
            wait(1);
            
            if(!Button_Sel1){
                i2c.write(Sound, &n, 1);//Start sound
            }
            
            wait(0.5);                  //Flashing to sync with sound
            LED_Launch=1;
            DisplayNumber(15,15,3,15,15);
            wait(0.5);
            LED_Launch=0;
            wait(0.5);
            LED_Launch=1;
            DisplayNumber(15,15,2,15,15);
            wait(0.5);
            LED_Launch=0;
            wait(0.5);
            LED_Launch=1;
            DisplayNumber(15,15,1,15,15);
            wait(0.5);
            LED_Launch=0;
            wait(0.5);
            LED_Launch=1;
            timer=Start;                //Start the timer
            LED_Timer=1;
            wait(2);
            LED_Launch=0;               //Turn off the light
            wait(0.2f);
        }
        
        if(Button_Reset && (timer==Start)){
            char n='F';
            timer=Pause;
            if(!Button_Sel1){
                i2c.write(Sound, &n, 1);    //End sound
            }
            wait(0.1f);
            while(Button_Reset){}
            LED_Timer=0;
            LED_Finish=1;
            wait(0.2);
        }
        
        if(Button_Reset && (timer==Pause)){
            timer=Reset;
            LED_Finish=0;
            wait(0.2);
        }
        
        if(Camera && (timer==Start)){
            char n='F';
            timer=Pause;
            if(!Button_Sel1){
                i2c.write(Sound, &n, 1);    //End sound
            }
            LED_Timer=0;
            LED_Finish=1;
            wait(0.2);
        }
        
    }
    
}
