#include "mbed.h"
#include "EthernetInterface.h"
#include <string> 


const char* ECHO_SERVER_ADDRESS = "10.2.134.30";
const int ECHO_SERVER_PORT = 7;

DigitalOut led1(D7);
DigitalOut led2(D6);
DigitalOut led3(D5);
DigitalOut led4(D4);

InterruptIn DataSwitch1(D3);
InterruptIn DataSwitch2(D2);
InterruptIn DataSwitch3(D1);
InterruptIn DataSwitch4(D0);


int prev_dataset = 0;
char json_str[100];
int button = 0;
string channel = ("channel");
char dataset = '1';


void dataset1_cb() 
{   
    
    button = 1; 
}
void dataset2_cb() 
{
    
    button = 2;  
}
void dataset3_cb() 
{
    
    button = 3;    
}
void dataset4_cb() 
{
    
    button = 4; 
}

int main() 
{
    
    DataSwitch1.rise(&dataset1_cb);
    DataSwitch2.rise(&dataset2_cb);
    DataSwitch3.rise(&dataset3_cb);
    DataSwitch4.rise(&dataset4_cb);

    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("\nClient IP Address is %s\n", eth.getIPAddress());
    
    // Connect to Server
    TCPSocketConnection socket;
    while (socket.connect(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT) < 0) 
    {
        printf("Unable to connect to (%s) on port (%d)\n", ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
        wait(1);
    }
    printf("Connected to Server at %s\n",ECHO_SERVER_ADDRESS);
    
    while(1)
    {   if (dataset != prev_dataset)
        {
            switch(dataset)
            {   
                case(0):
                    break;
                case(1):
                    channel = "";
                    dataset = '1';
                    sprintf (json_str, "{\"channel\":%s,\"dataset\":%c\"}", channel, dataset);
                    //printf("Sending  message to Server : '%s' \n",json_str);
                    socket.send_all(json_str, sizeof(json_str) - 1);
                    led1=1;
                    led2=0;
                    led3=0;
                    led4=0;
                    break;
                case(2):
                    channel = "";
                    dataset = '2';
                    sprintf (json_str, "{\"channel\":%s,\"dataset\":%c\"}", channel, dataset);
                    //printf("Sending  message to Server : '%s' \n",json_str);
                    socket.send_all(json_str, sizeof(json_str) - 1);
                    led1=0;
                    led2=1;
                    led3=0;
                    led4=0;
                    break;
                case(3):
                    channel = "";
                    dataset = '3';
                    sprintf (json_str, "{\"channel\":%s,\"dataset\":%c\"}", channel, dataset);
                    //printf("Sending  message to Server : '%s' \n",json_str);
                    socket.send_all(json_str, sizeof(json_str) - 1);
                    led1=0;
                    led2=0;
                    led3=1;
                    led4=0;
                    break;
                case(4):
                    channel = "";
                    dataset = '4';
                    sprintf (json_str, "{\"channel\":%s,\"dataset\":%c\"}", channel, dataset);
                    //printf("Sending  message to Server : '%s' \n",json_str);
                    socket.send_all(json_str, sizeof(json_str) - 1);
                    led1=0;
                    led2=0;
                    led3=0;
                    led4=1;       
                    break;
                default:
                    break;  
            }
            prev_dataset = dataset;
                    // Receive message from server
            char buf[256];
            int n = socket.receive(buf, 256);
            buf[n] = '\0';
            printf("Received message from server: '%s'\n", buf);
        }
        
    

    }
    
    // Clean up
    socket.close();
    eth.disconnect();
    
    while(true) {}
}


