#ifndef MAIN_H
#define MAIN_H

#include "mbed.h"
#include "WS2812.h"
#include "PixelArray.h"
#include "PinDetect.h"

#define WS2812_BUF 122
#define NUM_COLORS 6
#define NUM_LEDS_PER_COLOR 1

//-------- Colours -----------
#define RED 0x2f0000
#define YELLOW 0x2f2f00
#define GREEN 0x002f00
#define LIGHTBLUE 0x002f2f
#define DARKBLUE 0x00002f
#define BLUE 0x0000ff // Player scored a goal
#define PINK 0x2f002f
#define OFF 0x000000
#define WHITE 0xffffaa
#define ARMBLUE 0x128BAB
#define PURPLE 0xff0055 // Player has conceded a goal

// Goal Sensors
AnalogIn robotBreakBeam(A0);
AnalogIn playerBreakBeam(A1);

// K64F On-board LED
DigitalOut led_green(LED_GREEN, 1);

//K64F On-board Switches
DigitalIn PB1(PTC6);
DigitalIn PB2(PTA4);
PinDetect idleButton(PTC11);

// SERIAL
RawSerial pc(USBTX, USBRX); // tx, rx

// LED STRIPS
// See the program page for information on the timing numbers
// The given numbers are for the K64F
WS2812 robotScoreLED(D3, WS2812_BUF, 0, 5, 5, 0);
WS2812 playerScoreLED(D5,WS2812_BUF, 0, 5, 5, 0);
PixelArray robotScorePx(WS2812_BUF);
PixelArray playerScorePx(WS2812_BUF);


// LED Variables
bool seg1A, seg1B, seg1C, seg1D, seg1E, seg1F, seg1G;
int mainArray[11][122];
int rand_colors[] = {0x00FF00, 0x7FFF00, 0xFFFF00, 0xFF7F00, 0xFF0000, 0xFE00FF, 0x7F00FF, 0x0000FF, 0x007FFF, 0x00FFFE, 0x00FF7F};

// Score counters
int robotScore;
int playerScore;
int scoreLimit = 3;
bool finishedGame = false;
int endFlashes = 3;
int numFlashes;

// Flags
volatile int idle_flag = 0;
volatile int idle_button_pressed = 0;
volatile int previous_state = 0;

// Robot Bream Beam value
double prevRbbValue; // Previous Robot break beam value
double prevPbbValue; // Previous player break beam value

// FUNCTION DECLERATIONS
void Setup();
void SetNumberPatterns(); // sets segment patterns for numbers
void SetLEDArray(int x); // sets segment patterns in mainArray
void WriteScores(); // writes scores to the LEDs
void WritePxAnimation(int line_num,bool isRobot,bool colour); // writes mainArray to either LED buffer in blue or random colours

// Protocols for handling goals and whether the player or robot has won
void HandleGoal(bool hasRobotScored); 
void HandleWin();

// Animation for scoring a goal and winning the game
void GoalAnimation(bool hasRobotScored);
void WinAnimation(bool isRobotWinner);

// Decorative Animations
void CircleAnimation(bool robot, bool robotColour,bool player, bool playerColour, int numberOfRepitions);
void FigureOf8Animation(bool robot, bool robotColour,bool player, bool playerColour, int numberOfRepitions);
void DrainAnimation(bool robot, bool robotColour, bool player, bool playerColour);

// Animations for writing and deleting displayed numbers
void ZeroInAnimation(bool robot, bool robotColour,bool player, bool playerColour);
void ZeroOutAnimation(bool robot, bool robotColour,bool player, bool playerColour);
void OneInAnimation(bool robot, bool robotColour,bool player, bool playerColour);
void OneOutAnimation(bool robot, bool robotColour,bool player, bool playerColour);
void TwoInAnimation(bool robot, bool robotColour,bool player, bool playerColour);
void TwoOutAnimation(bool robot, bool robotColour,bool player, bool playerColour);
void ThreeInAnimation(bool robot, bool robotColour,bool player, bool playerColour);
void ThreeOutAnimation(bool robot, bool robotColour,bool player, bool playerColour);

// Protocol and transition functions for Idle and Play states
void IdleStateProtocol();
void PlayStateProtocol();
void PlayToIdleTransition();
void IdleToPlayTransition();

// ISRs
void idleButtonISR();


#endif