#include "mbed.h"
#include "SeeedStudioShieldBot.h"

SeeedStudioShieldBot bot(
    D8, D9, D11,             // Left motor pins
    D12, D10, D13,            // Right motor pins
    A0, A1, A2, A3, D4      // Sensors pins
);

//DigitalIn ReadSensorsEnabled(A5, PullUp);
DigitalOut led(D6);

/** Returns an integer correspondingly if an object is detected within 10cm.
 *  Uses the Sharp GP2Y0D810Z0F Digital Distance Sensor - 10cm
 *  @param bumpSensor the pin the bump sensor is connected to.
 *  @return 1 if something is detected, 0 otherwise.
 */
int bumpSensor(PinName bumpSensor)
{
    DigitalIn bump(bumpSensor);       // the 10 cm Sharp GP2Y0D810Z0F Digital Distance Sensor
    if(bump.read() == 0)
        return 1;
    else
        return 0;
}

// Line Tracking Model with Bump sensor V2
int main()
{
    // Enable motors
    bot.enable_right_motor();
    bot.enable_left_motor();

    while(1)
    {
        //wait_ms(200);
        if(bumpSensor(D7) == 1)
        {
            bot.stopAll();
            while(bumpSensor(D7) == 1);
            bot.enable_left_motor();
            bot.enable_right_motor();
        }
        while(bumpSensor(D7) == 0 && bot.get_IR()[2] == 0)
        {
            led = 1; 
            bot.forward(0.15);
            //wait_ms(100);
        }
        while(bumpSensor(D7) == 0 && bot.get_IR()[2] == 1)
        {
            bot.left(0.15);
            led = 0; 
        }
    }
}
/**
SeeedStudioShieldBot bot(
    D8, D9, D11,             // Left motor pins
    D12, D10, D13,            // Right motor pins
    A0, A1, A2, A3, D4      // Sensors pins
);

DigitalOut led(PB_4);

/// Returns the distance of the nearest object.
 *  Uses the HC-SR04 Distance Sensor
 *  @return the distance in cm.
///
double distanceSensor(PinName trigPin, PinName echoPin)
{
    DigitalOut trig(trigPin);       // Sends out an Ultasonicsonic signal
    DigitalIn echo(echoPin);        // Recieves an Ultasonicsonic signal
    Timer timer;        // for measuring the duration of the signal's joyless journey
    
    timer.reset();
    trig = 0;
    wait_us(2);
    trig = 1;
    wait_us(10);
    trig = 0;
    while(echo == 0);
    timer.start();
    while(echo == 1);
    timer.stop();

    // Distance = ( (Duration of travel) * (Speed of Ultasonicsonic: 340m/s) ) / 2
    return (timer.read_us() * 0.034) / 2.0;        // Microseconds are used for accuracy
}


int main()                                          // Example for the Distance Sensor
{
    
    while(1) 
    {  
        distance = distanceSensor(PA_10, PB_3);
        if(distance < 10)
            led = 1;
        else
            led =0;
        wait(0.1);          // For the LED's safety so it doesn't flicker as much and die x_x
    }
}

Sample on getting data from the light sensors 
int main()                                         // Example for the values from the sensor
{
    int distance, *arr; 
    while(1) 
    {  
        arr = bot.get_IR();
        if(arr[4] == 0)
            led = 1;
        else
            led =0;
        wait(0.1);          // For the LED's safety so it doesn't flicker as much and die x_x
    }
}
*/