#include "mbed.h"
// us means microseconds

/** Parallax Robot Shield Control Class
 *
 */
class ParallaxRobotShield
{
    public:
    
        /** Create a new ParallaxRobotShield object on any mbed pin
        *
        * @param leftServoPin Left Servomotor Signal pin
        * @param rightServoPin Right Servomotor Signal pin
        */
        //ParallaxRobotShield(PinName leftServoPin, PinName rightServoPin);
        
        /** Create a new ParallaxRobotShield object on any mbed pin
        *
        * @param leftServoPin Left Servomotor Signal pin - default D10
        * @param rightServoPin Right Servomotor Signal pin - - default D11
        * @param leftWhiskerPin Whisker digital pin connection
        * @param rightWhiskerPin Whisker digital pin connection
        */
        ParallaxRobotShield(PinName leftServoPin = D10, PinName rightServoPin = D11, PinName leftWhiskerPin = NC, PinName rightWhiskerPin = NC);
        
        /** Change the position of the servo. Position in us.
         *
         * @param NewPos The new value of the servos position (us)
         */
        //void SetPosition(int NewPos);
    
    
        /** Enable the servo. Without enabling, the servo won't be running. Startposition and period both in us.
         *
         * @param StartPos The position of the servo to start (us) 
         * @param Period The time between every pulse. 20000 us = 50 Hz(standard) (us)
         */
        //void Enable(int StartPos, int Period);
        
        
        /** Disable the servo. After disabling the servo won't get any signal anymore
         *
         */
        //void Disable();
        
        
        /** Create a robot shield object************************************************************************************************
         *
         * @param leftServo Left Servomotor Signal pin, default D13
         * @param rightServoPin RightServomotor Signal pin, default D14
         * @param whisker Whisker digital pin connection, default D7
         * @param lightSensor Sensor signal pin, default D6
         * @param bumpSensor Sensor signal pin, default D5
         * @param HCSR04sensor Sensor in-right pin, default D4 // For later - Need Trigger and RCC
         */
//------>ParallaxRobotShield(PinName leftServo, PinName rightServoPin , PinName whisker, PinName lightSensor, PinName bumpSensor);

        

        /** Switch on the left servo at the given speed. Can be used with loops to run the left servomotor.
         *  @param speed The speed, from 0 to 100 at which to spin the servomotor.
         */
        void left_servo(int speed);
        
        
        
        /** Switch on the right servo at the given speed. Can be used with loops to run the right servomotor.
         *  @param speed The speed, from 0 to 100 at which to spin the servomotor.
         */
        void right_servo(int speed);
        
        
        
        /** Switch on both servomotors, forwards at the given speed.
         *  @param speed The speed, from 0 to 100 at which to spin the servomotors.
         */
        void forward(int speed);
        
        
        
        /** Switch on both servomotors, backwards at the given speed.
         *  @param speed The speed, from 0 to 100 at which to spin the servomotors.
         */
        void backward(int speed);
        
        
        
        /** Switch on both servomotors at the given speed, in opposite directions so as to turn left.
         *  @param speed The speed, from 0 to 100 at which to spin the servomotors.
        */
        void left(int speed);
        
        
        
        /** Switch on both servomotors at the given speed, in opposite directions so as to turn right.
         *  @param speed The speed, from 0 to 100 at which to spin the servomotors.
         */
        void right(int speed);
        
        
        
        /** Turns left.
         *  @param speed The speed, from 0 to 100 at which to spin the servomotors.
         */
        void turn_left(int speed);
        
        
        
        /** Turns right.
         *  @param speed The speed, from 0 to 100 at which to spin the servomotors.
         */
        void turn_right(int speed);
        
        
        
        /** Disable the left motor
         */
        void disable_left_motor();  // Just for internal functions
        
        
        
        /** Disable the right servomotor
         */
        void disable_right_motor(); // Just for internal functions
        
        
        
        /** Enable the left servomotor
         */
        void enable_left_motor();
        
        
        
        /** Enable the left servomotor
         */
        void enable_right_motor();
        
        
        
        /** Stop a chosen motor.
         *  @param motor Number, either, 1 = Right or 2 = Left, choosing the motor.
         */
        void stop(int motor);
        
        
        
        /** Stop left servomotor.
         */
        void stopLeft();
        
        
        
        /** Stop right servomotor.
         */
        void stopRight();
        
        
        
        /** Stop both servomotors at the same time. Different from disable.
         */
        void stopAll();
        
        
        
        // Need to do something to do with detected line...
        
        /** Gives an indication of the data given by the reflectivity sensors.*************************************************************************************
         */
        float line_position();
        
        //DigitalIn lightSensor;
        //DigitalIn bumpSensor;
        //DigitalIn whisker;
        
        
        /** Turns on the appropriate LED to signal if the corresponding whisker is in contact.
         */
        //void whiskersLED();
        
        /** Returns an integer corresponding to the state of the left whisker.
         *  @return 1 if the Left whisker is in contact, 0 otherwise.
         */
        int leftWhiskerContact();
        
        /** Returns an integer corresponding to the state of the right whisker.
         *  @return 1 if the Right whisker is in contact, 0 otherwise.
         */
        int rightWhiskerContact();
        
        
        /** Controls the servomotors accordingly if the whiskers come in contact.
         */
        void whisker();
        
        
    private: // Use whatever data type you need
    
        //void StartPulse();
        //void EndPulse();

        int leftPosition;
        int rightPosition;

        DigitalOut leftServo;
        DigitalOut rightServo;
        
        DigitalIn leftWhisker;
        DigitalIn rightWhisker;
        
        Ticker leftPulse;
        Ticker rightPulse;
        
        Timeout leftPulseStop;
        Timeout rightPulseStop;
        
        //PwmOut rightServo;
        //PwmOut leftServo;
        
};