/********************************************************
file description: this new miniTLS program build the connection
with the website https://httpbin.org/.
interface :ethernet
Mbed-RTOS:No
author: Jacob Shi
*************************************************************/
#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"
#include "MiniTLS-GPL/cpp/MiniTLS.h"
 
MiniTLS miniTLS;
EthernetInterface eth;
HTTPClient http;
char str[512];
HTTPText strtest(str,512);
HTTPText inText(str, 512);
HTTPMap map;

const uint8_t pub_key[] = {
0x30,0x82,0x01,0x0a,0x02,0x82,0x01,0x01,0x00,0xd3,0x53,0x1f,0xb2,0x7e,0x68,0x51,0x5b,
0x12,0xd1,0x45,0x0e,0x1f,0xa3,0x5e,0x24,0x17,0x78,0x99,0xe9,0x43,0x13,0xaf,0x9c,0x55,
0xae,0xe2,0xe1,0x84,0x4e,0xd7,0xe5,0x4e,0xcc,0x71,0xb6,0x9b,0x32,0x71,0x6f,0x17,0xc6,
0x91,0xe6,0x91,0x3d,0x19,0xb0,0xb7,0x70,0xf1,0xc4,0xf7,0x2e,0xe0,0x0a,0x7d,0x58,0x8d,
0xd3,0x03,0x6a,0xa2,0x33,0xb1,0x1b,0x1d,0x73,0x29,0xc1,0xd7,0x83,0x05,0xc4,0x44,0x12,
0x13,0x51,0x57,0x15,0x49,0x8f,0x22,0xe9,0xa8,0x04,0xc4,0x9b,0x33,0xdc,0xaf,0x82,0x10,
0x7b,0xbd,0x8b,0x1c,0x55,0x18,0xa4,0xa7,0xed,0x85,0xad,0x94,0x77,0xe8,0xb4,0xc2,0x0e,
0x33,0x56,0x01,0x4e,0x62,0x38,0x56,0x06,0xad,0x9a,0xe4,0x72,0xcf,0x56,0x91,0x36,0xc6,
0xa5,0xdc,0x9e,0xf1,0xb3,0xf7,0xa3,0xb9,0xae,0x73,0x1a,0x16,0x36,0x22,0xd8,0x06,0x23,
0xaa,0x46,0xde,0x59,0x43,0xee,0xc3,0xcd,0xd1,0x96,0x65,0x56,0x32,0x23,0x60,0x46,0x3b,
0x35,0xf6,0xba,0x17,0xcb,0xcb,0xa9,0x59,0x8a,0xbe,0x2d,0x32,0xc6,0x74,0x30,0x29,0x25,
0x13,0x9d,0x1b,0x04,0xa7,0x42,0x8a,0xe5,0x49,0x93,0x26,0x9a,0x71,0x41,0xe4,0xd3,0x91,
0xd7,0xee,0xeb,0x73,0x5a,0x08,0x87,0x2b,0x5f,0xff,0x45,0xb2,0xa6,0x15,0x00,0xc1,0x06,
0xcc,0x83,0xa7,0xeb,0x74,0x25,0xe2,0x11,0xbc,0x00,0x0a,0xc9,0x51,0xbe,0x38,0x9c,0x91,
0xcc,0x8e,0x8a,0xf7,0xff,0x58,0x3f,0xb7,0xea,0xc8,0x38,0x56,0xe3,0x1c,0x05,0xb4,0xb4,
0x29,0x22,0x86,0x67,0xfb,0x48,0xb8,0xa4,0x38,0x83,0x02,0x03,0x01,0x00,0x01
};

const uint8_t certificate[] = {
0x30,0x82,0x05,0x50,0x30,0x82,0x04,0x38,0xa0,0x03,0x02,0x01,0x02,0x02,0x11,0x00,
0xa2,0xad,0xf5,0x01,0x1f,0xde,0xa8,0x09,0xc5,0xd7,0x72,0x46,0x70,0xab,0x74,0x57,
0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x0b,0x05,0x00,0x30,
0x81,0x90,0x31,0x0b,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x47,0x42,0x31,
0x1b,0x30,0x19,0x06,0x03,0x55,0x04,0x08,0x13,0x12,0x47,0x72,0x65,0x61,0x74,0x65,
0x72,0x20,0x4d,0x61,0x6e,0x63,0x68,0x65,0x73,0x74,0x65,0x72,0x31,0x10,0x30,0x0e,
0x06,0x03,0x55,0x04,0x07,0x13,0x07,0x53,0x61,0x6c,0x66,0x6f,0x72,0x64,0x31,0x1a,
0x30,0x18,0x06,0x03,0x55,0x04,0x0a,0x13,0x11,0x43,0x4f,0x4d,0x4f,0x44,0x4f,0x20,
0x43,0x41,0x20,0x4c,0x69,0x6d,0x69,0x74,0x65,0x64,0x31,0x36,0x30,0x34,0x06,0x03,
0x55,0x04,0x03,0x13,0x2d,0x43,0x4f,0x4d,0x4f,0x44,0x4f,0x20,0x52,0x53,0x41,0x20,
0x44,0x6f,0x6d,0x61,0x69,0x6e,0x20,0x56,0x61,0x6c,0x69,0x64,0x61,0x74,0x69,0x6f,
0x6e,0x20,0x53,0x65,0x63,0x75,0x72,0x65,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x20,
0x43,0x41,0x30,0x1e,0x17,0x0d,0x31,0x35,0x30,0x31,0x31,0x36,0x30,0x30,0x30,0x30,
0x30,0x30,0x5a,0x17,0x0d,0x31,0x36,0x30,0x31,0x31,0x36,0x32,0x33,0x35,0x39,0x35,
0x39,0x5a,0x30,0x5b,0x31,0x21,0x30,0x1f,0x06,0x03,0x55,0x04,0x0b,0x13,0x18,0x44,
0x6f,0x6d,0x61,0x69,0x6e,0x20,0x43,0x6f,0x6e,0x74,0x72,0x6f,0x6c,0x20,0x56,0x61,
0x6c,0x69,0x64,0x61,0x74,0x65,0x64,0x31,0x1e,0x30,0x1c,0x06,0x03,0x55,0x04,0x0b,
0x13,0x15,0x45,0x73,0x73,0x65,0x6e,0x74,0x69,0x61,0x6c,0x53,0x53,0x4c,0x20,0x57,
0x69,0x6c,0x64,0x63,0x61,0x72,0x64,0x31,0x16,0x30,0x14,0x06,0x03,0x55,0x04,0x03,
0x14,0x0d,0x2a,0x2e,0x68,0x74,0x74,0x70,0x62,0x69,0x6e,0x2e,0x6f,0x72,0x67,0x30,
0x82,0x01,0x22,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x01,
0x05,0x00,0x03,0x82,0x01,0x0f,0x00,0x30,0x82,0x01,0x0a,0x02,0x82,0x01,0x01,0x00,
0xd3,0x53,0x1f,0xb2,0x7e,0x68,0x51,0x5b,0x12,0xd1,0x45,0x0e,0x1f,0xa3,0x5e,0x24,
0x17,0x78,0x99,0xe9,0x43,0x13,0xaf,0x9c,0x55,0xae,0xe2,0xe1,0x84,0x4e,0xd7,0xe5,
0x4e,0xcc,0x71,0xb6,0x9b,0x32,0x71,0x6f,0x17,0xc6,0x91,0xe6,0x91,0x3d,0x19,0xb0,
0xb7,0x70,0xf1,0xc4,0xf7,0x2e,0xe0,0x0a,0x7d,0x58,0x8d,0xd3,0x03,0x6a,0xa2,0x33,
0xb1,0x1b,0x1d,0x73,0x29,0xc1,0xd7,0x83,0x05,0xc4,0x44,0x12,0x13,0x51,0x57,0x15,
0x49,0x8f,0x22,0xe9,0xa8,0x04,0xc4,0x9b,0x33,0xdc,0xaf,0x82,0x10,0x7b,0xbd,0x8b,
0x1c,0x55,0x18,0xa4,0xa7,0xed,0x85,0xad,0x94,0x77,0xe8,0xb4,0xc2,0x0e,0x33,0x56,
0x01,0x4e,0x62,0x38,0x56,0x06,0xad,0x9a,0xe4,0x72,0xcf,0x56,0x91,0x36,0xc6,0xa5,
0xdc,0x9e,0xf1,0xb3,0xf7,0xa3,0xb9,0xae,0x73,0x1a,0x16,0x36,0x22,0xd8,0x06,0x23,
0xaa,0x46,0xde,0x59,0x43,0xee,0xc3,0xcd,0xd1,0x96,0x65,0x56,0x32,0x23,0x60,0x46,
0x3b,0x35,0xf6,0xba,0x17,0xcb,0xcb,0xa9,0x59,0x8a,0xbe,0x2d,0x32,0xc6,0x74,0x30,
0x29,0x25,0x13,0x9d,0x1b,0x04,0xa7,0x42,0x8a,0xe5,0x49,0x93,0x26,0x9a,0x71,0x41,
0xe4,0xd3,0x91,0xd7,0xee,0xeb,0x73,0x5a,0x08,0x87,0x2b,0x5f,0xff,0x45,0xb2,0xa6,
0x15,0x00,0xc1,0x06,0xcc,0x83,0xa7,0xeb,0x74,0x25,0xe2,0x11,0xbc,0x00,0x0a,0xc9,
0x51,0xbe,0x38,0x9c,0x91,0xcc,0x8e,0x8a,0xf7,0xff,0x58,0x3f,0xb7,0xea,0xc8,0x38,
0x56,0xe3,0x1c,0x05,0xb4,0xb4,0x29,0x22,0x86,0x67,0xfb,0x48,0xb8,0xa4,0x38,0x83,
0x02,0x03,0x01,0x00,0x01,0xa3,0x82,0x01,0xd7,0x30,0x82,0x01,0xd3,0x30,0x1f,0x06,
0x03,0x55,0x1d,0x23,0x04,0x18,0x30,0x16,0x80,0x14,0x90,0xaf,0x6a,0x3a,0x94,0x5a,
0x0b,0xd8,0x90,0xea,0x12,0x56,0x73,0xdf,0x43,0xb4,0x3a,0x28,0xda,0xe7,0x30,0x1d,
0x06,0x03,0x55,0x1d,0x0e,0x04,0x16,0x04,0x14,0x6f,0xa3,0xdd,0xb6,0x02,0x12,0x82,
0x4a,0x15,0xe0,0x2b,0x94,0xe4,0x93,0x67,0xda,0xf2,0xa8,0x60,0xa1,0x30,0x0e,0x06,
0x03,0x55,0x1d,0x0f,0x01,0x01,0xff,0x04,0x04,0x03,0x02,0x05,0xa0,0x30,0x0c,0x06,
0x03,0x55,0x1d,0x13,0x01,0x01,0xff,0x04,0x02,0x30,0x00,0x30,0x1d,0x06,0x03,0x55,
0x1d,0x25,0x04,0x16,0x30,0x14,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x01,
0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x02,0x30,0x4f,0x06,0x03,0x55,0x1d,
0x20,0x04,0x48,0x30,0x46,0x30,0x3a,0x06,0x0b,0x2b,0x06,0x01,0x04,0x01,0xb2,0x31,
0x01,0x02,0x02,0x07,0x30,0x2b,0x30,0x29,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,
0x02,0x01,0x16,0x1d,0x68,0x74,0x74,0x70,0x73,0x3a,0x2f,0x2f,0x73,0x65,0x63,0x75,
0x72,0x65,0x2e,0x63,0x6f,0x6d,0x6f,0x64,0x6f,0x2e,0x63,0x6f,0x6d,0x2f,0x43,0x50,
0x53,0x30,0x08,0x06,0x06,0x67,0x81,0x0c,0x01,0x02,0x01,0x30,0x54,0x06,0x03,0x55,
0x1d,0x1f,0x04,0x4d,0x30,0x4b,0x30,0x49,0xa0,0x47,0xa0,0x45,0x86,0x43,0x68,0x74,
0x74,0x70,0x3a,0x2f,0x2f,0x63,0x72,0x6c,0x2e,0x63,0x6f,0x6d,0x6f,0x64,0x6f,0x63,
0x61,0x2e,0x63,0x6f,0x6d,0x2f,0x43,0x4f,0x4d,0x4f,0x44,0x4f,0x52,0x53,0x41,0x44,
0x6f,0x6d,0x61,0x69,0x6e,0x56,0x61,0x6c,0x69,0x64,0x61,0x74,0x69,0x6f,0x6e,0x53,
0x65,0x63,0x75,0x72,0x65,0x53,0x65,0x72,0x76,0x65,0x72,0x43,0x41,0x2e,0x63,0x72,
0x6c,0x30,0x81,0x85,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x01,0x04,0x79,
0x30,0x77,0x30,0x4f,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x02,0x86,0x43,
0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x63,0x72,0x74,0x2e,0x63,0x6f,0x6d,0x6f,0x64,
0x6f,0x63,0x61,0x2e,0x63,0x6f,0x6d,0x2f,0x43,0x4f,0x4d,0x4f,0x44,0x4f,0x52,0x53,
0x41,0x44,0x6f,0x6d,0x61,0x69,0x6e,0x56,0x61,0x6c,0x69,0x64,0x61,0x74,0x69,0x6f,
0x6e,0x53,0x65,0x63,0x75,0x72,0x65,0x53,0x65,0x72,0x76,0x65,0x72,0x43,0x41,0x2e,
0x63,0x72,0x74,0x30,0x24,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x86,
0x18,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x6f,0x63,0x73,0x70,0x2e,0x63,0x6f,0x6d,
0x6f,0x64,0x6f,0x63,0x61,0x2e,0x63,0x6f,0x6d,0x30,0x25,0x06,0x03,0x55,0x1d,0x11,
0x04,0x1e,0x30,0x1c,0x82,0x0d,0x2a,0x2e,0x68,0x74,0x74,0x70,0x62,0x69,0x6e,0x2e,
0x6f,0x72,0x67,0x82,0x0b,0x68,0x74,0x74,0x70,0x62,0x69,0x6e,0x2e,0x6f,0x72,0x67,
0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x0b,0x05,0x00,0x03,
0x82,0x01,0x01,0x00,0x39,0x44,0xc1,0x26,0xa8,0xc1,0x3d,0x04,0x48,0x3d,0x11,0x21,
0x46,0x60,0xb7,0x8a,0xaf,0x4f,0xff,0x5e,0xda,0xf5,0x78,0x4b,0x3a,0x90,0xcc,0xc2,
0xfa,0xdc,0xa6,0xa5,0x48,0x68,0x1e,0x06,0x79,0x62,0xa4,0x9a,0x6d,0x66,0x03,0x68,
0x95,0x09,0xf8,0x77,0xab,0xfa,0x55,0x19,0xfa,0x82,0xbd,0x3b,0x12,0x26,0x5f,0x43,
0xfc,0x14,0xf2,0xac,0x9a,0x59,0x58,0x9e,0x26,0x6b,0x64,0xb8,0x41,0x47,0x67,0xd6,
0x9d,0x9e,0xba,0x76,0xa7,0x2d,0x3d,0x00,0x68,0x0b,0xeb,0x38,0xc8,0x76,0xd5,0x7d,
0xa2,0x5e,0x5a,0x0b,0xb1,0x5d,0xb1,0x73,0x4b,0x8d,0x99,0x8b,0x85,0x11,0x2a,0xd6,
0x90,0xe8,0x8c,0xfc,0x23,0x2b,0x81,0x5f,0x55,0x06,0x2d,0x91,0x29,0x00,0x3f,0x53,
0x3e,0x8e,0x51,0x72,0x62,0xd1,0xba,0x62,0x18,0x53,0x21,0x6c,0xf1,0x15,0x54,0x47,
0xb5,0x23,0x13,0xd3,0xba,0xd7,0x5f,0xb4,0xe8,0xf7,0xbf,0x93,0x84,0x77,0x11,0x8c,
0xea,0x82,0x7c,0x3d,0xc2,0x4b,0x1c,0xb9,0x5d,0x92,0xfd,0x2e,0x2c,0x2f,0x05,0xbb,
0x04,0x0c,0xd4,0x56,0x53,0x2b,0xc7,0xce,0xd9,0x23,0xbe,0x7f,0x87,0xd2,0xae,0xf2,
0xd1,0x53,0xd2,0xe5,0xc5,0x3c,0x09,0xcf,0x72,0xc6,0xdf,0xef,0xc1,0x48,0x44,0x09,
0x0e,0xa2,0x62,0xef,0x37,0xe4,0xea,0xa4,0x46,0xb1,0xe2,0x77,0xb6,0x9e,0x78,0xef,
0xa8,0x3a,0x96,0x4f,0x7a,0x77,0xc5,0x33,0x9b,0xa8,0xf2,0xce,0x86,0xca,0x53,0xeb,
0x08,0xf8,0xde,0xea,0x51,0xcb,0xcc,0x75,0xbe,0x8d,0x4b,0x35,0x4a,0x74,0x96,0xdd,
0x76,0xde,0x30,0x48,
};

int main() 
{
    Serial pc(USBTX, USBRX);
    pc.baud(9600);
    
    miniTLS.init();
    
    //Deterministic but this is an example!
    for(int i = 0; i < 32; i++)
    {
      uint32_t ticks = us_ticker_read();
      miniTLS.feedPRNG((uint8_t*)&ticks, sizeof(uint32_t));
    }
    
    miniTLS.addCertificate(certificate, sizeof(certificate), pub_key, sizeof(pub_key));
    
    eth.init(); //Use DHCP
 
    int ret = eth.connect();
    if(ret)
    {
      printf("connect() returned %d\r\n", ret);
    }
    
    //GET data
    printf("Trying to fetch page...\r\n");
    ret = http.del("https://httpbin.org/delete", &strtest, 128);
    if (!ret)
    {
      printf("Page fetched successfully - read %d characters\r\n", strlen(str));
      printf("Result: %s\r\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\r\n", ret, http.getHTTPResponseCode());
    }
    
    ret = http.get("https://httpbin.org/ip", &strtest, 128);
    if (!ret)
    {
      printf("Page fetched successfully - read %d characters\r\n", strlen(str));
      printf("Result: %s\r\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\r\n", ret, http.getHTTPResponseCode());
    }
    
    map.put("Hello", "World");
    map.put("test", "1234");
    printf("\nTrying to post data...\n");
    ret = http.post("https://httpbin.org/post", map, &inText);
    if (!ret)
    {
      printf("Page fetched successfully - read %d characters\r\n", strlen(str));
      printf("Result: %s\r\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\r\n", ret, http.getHTTPResponseCode());
    }
    
    
    strcpy(str, "This is a PUT test!");
    HTTPText outText(str);
    printf("\nTrying to put resource...\n");
    ret = http.put("https://httpbin.org/put", outText, &inText);
     if (!ret)
    {
      printf("Page fetched successfully - read %d characters\r\n", strlen(str));
      printf("Result: %s\r\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\r\n", ret, http.getHTTPResponseCode());
    }
    eth.disconnect();  
 
    while(1) {
    }
}