/*
MiniTLS - A super trimmed down TLS/SSL Library for embedded devices
Author: Donatien Garnier
Copyright (C) 2013-2014 AppNearMe Ltd

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*//**
 * \file tls_socket.h
 * \copyright Copyright (c) AppNearMe Ltd 2013
 * \author Donatien Garnier
 */

#ifndef TLS_SOCKET_H_
#define TLS_SOCKET_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/fwk.h"
#include "inc/minitls_errors.h"
/*
typedef struct __tls_record tls_record_t;
typedef struct __tls_handshake tls_handshake_t;*/

#include "tls_record.h"
#include "tls_handshake.h"
//#include "tls_ecc.h"
#include "minitls.h"

#include "tls_socket_defs.h"

minitls_err_t tls_socket_init(tls_socket_t* sock, minitls_t* minitls, uint8_t* write_buffer, size_t write_buffer_size, uint8_t* read_buffer, size_t read_buffer_size);

minitls_err_t tls_socket_connect(tls_socket_t* sock, const char* hostname, uint16_t port, int timeout);

void tls_socket_copy_session(tls_socket_t* to, tls_socket_t* from);

//Events API -- select like
minitls_err_t tls_socket_event_list_init(tls_socket_event_list_t* list);
minitls_err_t tls_socket_event_init_and_register(tls_socket_event_t* event, tls_socket_event_list_t* list, tls_socket_t* sock, bool read, bool write);
minitls_err_t tls_socket_event_list_wait(tls_socket_event_list_t* list, int timeout); //All events unregistered at the end of wait, timeout in ms, -1 for infinite timeout

//These calls are non-blocking
minitls_err_t tls_socket_read(tls_socket_t* socket, uint8_t* bytes, size_t max_size, size_t* read_size);
minitls_err_t tls_socket_write(tls_socket_t* socket, uint8_t* bytes, size_t size, size_t* written_size);

//These calls are blocking
minitls_err_t tls_socket_flush_read(tls_socket_t* socket, int timeout);
minitls_err_t tls_socket_flush_write(tls_socket_t* socket, int timeout);

//Called from record layer
minitls_err_t tls_socket_readable_callback(tls_socket_t* sock, buffer_t* buffer);

minitls_err_t tls_socket_close(tls_socket_t* sock);


#ifdef __cplusplus
}
#endif

#endif /* TLS_SOCKET_H_ */
