/*
MiniTLS - A super trimmed down TLS/SSL Library for embedded devices
Author: Donatien Garnier
Copyright (C) 2013-2014 AppNearMe Ltd

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*//**
 * \file tls_security.h
 * \copyright Copyright (c) AppNearMe Ltd 2013
 * \author Donatien Garnier
 */

#ifndef TLS_SECURITY_H_
#define TLS_SECURITY_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/fwk.h"

typedef enum __tls_security_type
{
  TLS_SECURITY_TYPE_NULL_NULL_NULL,
  TLS_SECURITY_TYPE_AES_128_CBC_SHA,
  TLS_SECURITY_TYPE_ARC4_SHA,
  __TLS_SECURITY_TYPE_MAX,
} tls_security_type_t;

#define TLS_HMAC_SHA1_KEY_SIZE 20 //Defined by TLS spec
#define TLS_ARC4_KEY_SIZE 16 //This is specific to TLS rather than the underlying cipher


#ifdef __cplusplus
}
#endif

#endif /* TLS_SECURITY_H_ */
