/*
MiniTLS - A super trimmed down TLS/SSL Library for embedded devices
Author: Donatien Garnier
Copyright (C) 2013-2014 AppNearMe Ltd

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*//**
 * \file socket.h
 * \copyright Copyright (c) AppNearMe Ltd 2013
 * \author Donatien Garnier
 */

#ifndef SOCKET_H_
#define SOCKET_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/fwk.h"

int socket_socket();
int socket_connect(int fd, const char* hostname, uint16_t port);

int socket_wait_readable(int fd, int timeout_ms);
int socket_wait_writeable(int fd, int timeout_ms);
int socket_recv(int fd, void* buf, size_t size);
int socket_send(int fd, void* buf, size_t size);

int socket_close(int fd);

#ifdef __cplusplus
}
#endif

#endif /* SOCKET_H_ */
