/*
MiniTLS - A super trimmed down TLS/SSL Library for embedded devices
Author: Donatien Garnier
Copyright (C) 2013-2014 AppNearMe Ltd

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*//**
 * \file minitls_config.h
 * \copyright Copyright (c) AppNearMe Ltd 2013
 * \author Donatien Garnier
 */

#ifndef MINITLS_CONFIG_H_
#define MINITLS_CONFIG_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/fwk.h"
#include "../config.h"

#define CRYPTO_ECC (MINITLS_CFG_KEY_ECDHE_ECDSA_192)
#define CRYPTO_ECC192 (MINITLS_CFG_KEY_ECDHE_ECDSA_192)
#define CRYPTO_MAX_ECC_KEY_SIZE (MINITLS_CFG_KEY_ECDHE_ECDSA_192?192:0)

#define CRYPTO_RSA (MINITLS_CFG_KEY_RSA_1024||MINITLS_CFG_KEY_RSA_2048)
#define CRYPTO_MAX_RSA_KEY_SIZE (MINITLS_CFG_KEY_RSA_2048?2048:(MINITLS_CFG_KEY_RSA_1024?1024:0))

#define CRYPTO_MAX_KEY_SIZE MAX(CRYPTO_MAX_ECC_KEY_SIZE,CRYPTO_MAX_RSA_KEY_SIZE) /*((4*32)+(MAX_ECC_KEY_SIZE*2))*/ //Bits

#define CRYPTO_AES_128 (MINITLS_CFG_CIPHER_AES_128)
#define CRYPTO_ARC4 (MINITLS_CFG_CIPHER_ARC4)

#define ENDIAN_LITTLE

#ifdef __cplusplus
}
#endif

#endif /* MINITLS_CONFIG_H_ */
