/*
MiniTLS - A super trimmed down TLS/SSL Library for embedded devices
Author: Donatien Garnier
Copyright (C) 2013-2014 AppNearMe Ltd

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*//**
 * \file crypto_rsa.h
 * \copyright Copyright (c) AppNearMe Ltd 2014
 * \author Donatien Garnier
 */

//This module has been adapted from libtomcrypt (http://libtom.org/)

#ifndef CRYPTO_RSA_H_
#define CRYPTO_RSA_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/fwk.h"
#include "inc/minitls_errors.h"
#include "inc/minitls_config.h"
#include "crypto_prng.h"
#include "crypto_math.h"

typedef struct __crypto_rsa_public_key
{
  fp_int N;
  fp_int e;
} crypto_rsa_public_key_t;

minitls_err_t crypto_rsa_pkcs1_import(crypto_rsa_public_key_t* key, const uint8_t* pkcs1, size_t size);
minitls_err_t crypto_rsa_encrypt(const crypto_rsa_public_key_t* public_key,
    uint8_t* plaintext, size_t plaintext_size,
    uint8_t* secret, size_t max_secret_size, size_t* secret_size, crypto_prng_t* prng);

#ifdef __cplusplus
}
#endif

#endif /* CRYPTO_RSA_H_ */
