/*
MiniTLS - A super trimmed down TLS/SSL Library for embedded devices
Author: Donatien Garnier
Copyright (C) 2013-2014 AppNearMe Ltd

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*//**
 * \file crypto_prng.h
 * \copyright Copyright (c) AppNearMe Ltd 2013
 * \author Donatien Garnier
 */

#ifndef CRYPTO_PRNG_H_
#define CRYPTO_PRNG_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/fwk.h"
#include "inc/minitls_errors.h"

#include "crypto_aes_128.h"
#include "crypto_sha1.h"

//This PRNG is based on Yarrow (AES128 + SHA1)

typedef struct __crypto_prng
{
  crypto_aes_128_t cipher;
  //crypto_sha1_t hash;
  uint32_t counter;
  uint8_t pool[SHA1_SIZE];
  uint8_t buf[AES_128_BLOCK_SIZE];
  size_t buf_pos;
  bool fed;
  rtos_mtx_t* mtx;
}
crypto_prng_t;

//Thread safe if mutex supplied (can be NULL)
void crypto_prng_init(crypto_prng_t* prng, rtos_mtx_t* mtx);
void crypto_prng_feed(crypto_prng_t* prng, uint8_t* data, size_t size);
void crypto_prng_update(crypto_prng_t* prng);
void crypto_prng_get(crypto_prng_t* prng, uint8_t* data, size_t size);

#ifdef __cplusplus
}
#endif

#endif /* CRYPTO_PRNG_H_ */
