/*
MiniTLS - A super trimmed down TLS/SSL Library for embedded devices
Author: Donatien Garnier
Copyright (C) 2013-2014 AppNearMe Ltd

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*//**
 * \file crypto_hmac_sha256.h
 * \copyright Copyright (c) AppNearMe Ltd 2013
 * \author Donatien Garnier
 */

#ifndef CRYPTO_HMAC_SHA256_H_
#define CRYPTO_HMAC_SHA256_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/fwk.h"
#include "crypto_sha256.h"

#define HMAC_SHA256_SIZE SHA256_SIZE //Same size that underlying hash function

typedef struct __crypto_hmac_sha256
{
  crypto_sha256_t hash;
  uint8_t key_pad[64];
} crypto_hmac_sha256_t;

void crypto_hmac_sha256_init(crypto_hmac_sha256_t* mac, const uint8_t* key, size_t size);
void crypto_hmac_sha256_update(crypto_hmac_sha256_t* mac, const uint8_t* data, size_t size);
void crypto_hmac_sha256_end(crypto_hmac_sha256_t* mac, uint8_t* out);


#ifdef __cplusplus
}
#endif

#endif /* CRYPTO_HMAC_SHA256_H_ */
